/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.VanillaStructures;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.registry.ModTags;

public final class SpawnHelper {
    private final ResourceKey<Level> dimId;
    private BlockPos initPos;
    private final Level level;
    private final Predicate<BlockPos> withinWorldBorder;
    private final Predicate<BlockPos> withinWorldBuildHeight;
    private final int minHeight;
    private final int maxHeight;
    private boolean isGravePlacement = false;
    private boolean graveInWater = true;
    private List<BlockPos> positions;
    private BlockPos spawnPos = null;
    private SpawnResult spawnType = SpawnResult.NONE;
    private int move = 0;

    public SpawnHelper(ServerLevel level, BlockPos initPos) {
        this.level = level;
        this.dimId = this.level.m_46472_();
        this.initPos = WorldHelper.getCloserValidPos(this.level, initPos);
        this.withinWorldBorder = pos -> this.level.m_6857_().m_61937_(pos);
        this.minHeight = this.level.m_141937_();
        this.maxHeight = this.minHeight + this.level.m_6042_().f_63865_();
        this.withinWorldBuildHeight = pos -> pos.m_123342_() >= this.minHeight && pos.m_123342_() < this.maxHeight;
    }

    public SpawnHelper withPlayerPreference(PlayerPreference playerPreference) {
        this.graveInWater = playerPreference.allowGraveInWater();
        return this;
    }

    private Location result() {
        return new Location(this.spawnPos, this.dimId);
    }

    public Location findSafePlace(int range, boolean withHeight) {
        this.initPositions(this.initPos.m_7918_(-range, withHeight ? -range : 0, -range), this.initPos.m_7918_(range, withHeight ? range : 0, range));
        for (BlockPos currentPos : this.positions) {
            if (!this.isIdealSpawnPlace(currentPos)) continue;
            return this.result();
        }
        return Location.ORIGIN;
    }

    public Location findStructurePlace(ResourceLocation structureRL) {
        this.initPos = new BlockPos(this.initPos.m_123341_(), WorldHelper.getY(structureRL, (ServerLevel)this.level, this.initPos.m_123341_(), this.initPos.m_123343_()), this.initPos.m_123343_());
        return this.findPlace(VanillaStructures.BURIED_TREASURE.is(structureRL));
    }

    public Location findSpawnPlace() {
        return this.findPlace();
    }

    public Location findGravePlace() {
        this.isGravePlacement = true;
        return this.findPlace();
    }

    private BlockPos getInitPosInFluid() {
        BlockPos adjustedPos = this.initPos;
        BlockState state = this.level.m_8055_(adjustedPos);
        FluidState fluidState = state.m_60819_();
        if (fluidState.m_76178_() && this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.m_7494_())) {
            state = this.level.m_8055_(adjustedPos);
            fluidState = state.m_60819_();
        }
        if (fluidState.m_76178_() || fluidState.m_205070_(FluidTags.f_13131_) && (!this.isGravePlacement || this.graveInWater)) {
            return this.initPos;
        }
        while (!this.level.m_8055_(adjustedPos).m_60819_().m_76178_()) {
            if (this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.m_7494_())) continue;
            return this.initPos;
        }
        return adjustedPos;
    }

    private Location findPlace() {
        return this.findPlace(false);
    }

    private Location findPlace(boolean uniquePosition) {
        Predicate<BlockPos> predicPos;
        Predicate<BlockPos> predicate = predicPos = this.isGravePlacement ? this::isIdealGravePlace : this::isIdealSpawnPlace;
        if (predicPos.test(this.initPos)) {
            return this.result();
        }
        if (uniquePosition) {
            this.initUniquePosition();
        } else {
            this.initChunkPositions();
        }
        BlockPos adjustedPos = this.getInitPosInFluid();
        boolean wasInLiquid = !adjustedPos.equals((Object)this.initPos);
        int maxY = Math.min(adjustedPos.m_123342_() + 70, this.maxHeight);
        int minY = Math.max(adjustedPos.m_123342_() - 70, this.minHeight);
        int yUp = adjustedPos.m_123342_();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        this.move = 0;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && predicPos.test(currentPos = new BlockPos(pos.m_123341_(), yUp, pos.m_123343_()))) {
                    return this.result();
                }
                if (!canGoDown || !predicPos.test(currentPos = new BlockPos(pos.m_123341_(), yDown, pos.m_123343_()))) continue;
                return this.result();
            }
            ++yUp;
            --yDown;
            ++this.move;
        }
        return this.isGravePlacement && SpawnResult.FIT.hasPattern(this.spawnType) ? this.result() : Location.ORIGIN;
    }

    private boolean isIdealSpawnPlace(BlockPos pos) {
        if (this.isSafePlace(pos) && this.isSafePlace(pos.m_7494_()) && this.isSafeGround(pos.m_7495_())) {
            this.setTypeAndPosition(SpawnResult.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isIdealGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            SpawnResult type = this.isSafeGround(pos.m_7495_()) ? (this.isSafePlace(pos.m_7494_()) ? (this.isSafePlace(pos.m_6630_(2)) ? SpawnResult.IDEAL : SpawnResult.FIT) : SpawnResult.NORMAL) : SpawnResult.MINIMAL;
            this.setTypeAndPosition(type, pos);
            return this.move > 40 ? SpawnResult.FIT.hasPattern(this.spawnType) : type == SpawnResult.IDEAL;
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        FluidState fluidState = state.m_60819_();
        return (fluidState.m_76178_() || this.graveInWater && fluidState.m_205070_(FluidTags.f_13131_)) && (state.m_247087_() || state.m_204336_(BlockTags.f_13041_)) && !state.m_155947_();
    }

    private void setTypeAndPosition(SpawnResult type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.initPositions(new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_()), new BlockPos(chunkPos.m_45608_(), 0, chunkPos.m_45609_()));
    }

    private void initPositions(BlockPos startPos, BlockPos endPos) {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = SpawnHelper.getAllInBox(startPos, endPos).sorted(Comparator.comparingDouble(pos -> Helper.getDistanceSq((Vec3i)pos, this.initPos.m_123341_(), 0, this.initPos.m_123343_()))).toList();
    }

    private void initUniquePosition() {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = ImmutableList.of((Object)this.initPos);
    }

    public static Stream<BlockPos> getAllInBox(BlockPos startPos, BlockPos endPos) {
        int minX = Math.min(startPos.m_123341_(), endPos.m_123341_());
        int maxX = Math.max(startPos.m_123341_(), endPos.m_123341_());
        int minY = Math.min(startPos.m_123342_(), endPos.m_123342_());
        int maxY = Math.max(startPos.m_123342_(), endPos.m_123342_());
        int minZ = Math.min(startPos.m_123343_(), endPos.m_123343_());
        int maxZ = Math.max(startPos.m_123343_(), endPos.m_123343_());
        Stream.Builder<BlockPos> list = Stream.builder();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    list.accept(new BlockPos(x, y, z));
                }
            }
        }
        return list.build();
    }

    private boolean isSafePlace(BlockPos pos) {
        boolean allowInWater;
        if (!this.withinWorldBorder.test(pos)) {
            return false;
        }
        BlockState state = this.level.m_8055_(pos);
        BlockPathTypes type = state.getBlockPathType((BlockGetter)this.level, pos, null);
        boolean bl = allowInWater = !this.isGravePlacement || this.graveInWater;
        if (type != null) {
            return switch (type) {
                case BlockPathTypes.OPEN, BlockPathTypes.BREACH -> true;
                case BlockPathTypes.WATER, BlockPathTypes.WATER_BORDER -> allowInWater;
                default -> false;
            };
        }
        Block block = state.m_60734_();
        if (state.m_60795_() || block == Blocks.f_50125_ || allowInWater && block == Blocks.f_49990_) {
            return true;
        }
        if (block == Blocks.f_49991_ || block == Blocks.f_50033_ || state.m_204336_(BlockTags.f_13076_) || block == Blocks.f_50685_ || block == Blocks.f_152499_ || state.m_204336_(BlockTags.f_13075_)) {
            return false;
        }
        VoxelShape collisionShape = state.m_60812_((BlockGetter)this.level, pos);
        if (collisionShape != Shapes.m_83040_()) {
            return false;
        }
        FluidState fluidState = state.m_60819_();
        return fluidState.m_76178_() || allowInWater && fluidState.m_205070_(FluidTags.f_13131_);
    }

    private boolean isSafeGround(BlockPos pos) {
        if (!this.withinWorldBorder.test(pos)) {
            return false;
        }
        BlockState state = this.level.m_8055_(pos);
        BlockPathTypes type = state.getBlockPathType((BlockGetter)this.level, pos, null);
        if (type != null) {
            return switch (type) {
                case BlockPathTypes.WATER, BlockPathTypes.WATER_BORDER, BlockPathTypes.BLOCKED, BlockPathTypes.WALKABLE, BlockPathTypes.LEAVES, BlockPathTypes.COCOA, BlockPathTypes.RAIL -> true;
                default -> false;
            };
        }
        Block block = state.m_60734_();
        if (block == Blocks.f_50196_ || block == Blocks.f_50125_ || this.graveInWater && block == Blocks.f_49990_) {
            return true;
        }
        if (!this.isGravePlacement && state.m_204336_(ModTags.Blocks.graves)) {
            return true;
        }
        if (state.m_60795_() || block == Blocks.f_50450_ || block == Blocks.f_50128_ || block == Blocks.f_50375_ || block == Blocks.f_50077_) {
            return false;
        }
        VoxelShape collisionShape = state.m_60812_((BlockGetter)this.level, pos);
        if (collisionShape == Shapes.m_83040_()) {
            FluidState fluidState = state.m_60819_();
            return !fluidState.m_76178_() && fluidState.m_205070_(FluidTags.f_13131_);
        }
        if (collisionShape == Shapes.m_83144_()) {
            return true;
        }
        return state.m_204336_(BlockTags.f_13031_) || state.m_204336_(BlockTags.f_215838_) || state.m_204336_(BlockTags.f_13030_) || state.m_204336_(BlockTags.f_13034_);
    }

    public static enum SpawnResult {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;


        public boolean hasPattern(SpawnResult actualPattern) {
            return this.ordinal() <= actualPattern.ordinal();
        }
    }
}

