/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.entity.ai.FollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.PacketHandler;

public class FriendlyAnimalImpl
implements IFriendlyAnimal {
    @Nullable
    protected UUID ownerId = null;
    private static final String FRIENDLY_OWNER_ID = "friendly_owner_id";

    @Override
    public Optional<UUID> getOwnerId() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public void setAI(PathfinderMob animal) {
        animal.m_21530_();
        animal.m_21553_(true);
        EntityHelper.resetAttackAction((LivingEntity)animal);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            animal.m_21508_(slot);
        }
        animal.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((Mob)animal, 1.2, 20.0f, 3.0f, false){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.mob);
            }
        });
        animal.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((Mob)animal){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.f_26135_);
            }
        });
        animal.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((Mob)animal){

            @Override
            protected Optional<Player> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.f_26135_);
            }
        });
        CallbackHandler.addFastCallback(() -> this.getOwnerId().ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new CMessageServant(animal.m_19879_(), (UUID)ownerId, false), (LivingEntity)animal)));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.ownerId != null) {
            nbt.m_128362_(FRIENDLY_OWNER_ID, this.ownerId);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128403_(FRIENDLY_OWNER_ID)) {
            this.ownerId = nbt.m_128342_(FRIENDLY_OWNER_ID);
        }
    }
}

