/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketLogReady(@Nullable BlockPos pos, String command, @Nonnull List<String> list) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolscontrol", "logready");

    public PacketLogReady(@Nullable BlockPos pos, String command, @Nonnull List<String> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<String>();
        this.list.addAll(list);
    }

    public static PacketLogReady create(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBoolean() ? buf.m_130135_() : null;
        String command = buf.m_130136_(Short.MAX_VALUE);
        List list = NetworkTools.readStringList((FriendlyByteBuf)buf);
        return new PacketLogReady(pos, command, list);
    }

    public void write(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        NetworkTools.writeStringList((FriendlyByteBuf)buf, this.list);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity te;
            if (this.pos == null) {
                ProcessorContainer container = PacketLogReady.getOpenContainer();
                if (container == null) {
                    Logging.log((String)"Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            }
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            }
        });
    }

    private static ProcessorContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof ProcessorContainer) {
            return (ProcessorContainer)container;
        }
        return null;
    }
}

