/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGraphicsReady(BlockPos pos, Map<String, GfxOp> gfxOps, List<String> orderedOps) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolscontrol", "graphics_ready");

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.gfxOps.size());
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            buf.m_130070_(entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeInt(this.orderedOps.size());
        for (String op : this.orderedOps) {
            buf.m_130070_(op);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketGraphicsReady create(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        HashMap<String, GfxOp> gfxOps = new HashMap<String, GfxOp>(size);
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130136_(Short.MAX_VALUE);
            GfxOp gfxOp = GfxOp.readFromBuf(buf);
            gfxOps.put(key, gfxOp);
        }
        size = buf.readInt();
        ArrayList<String> orderedOps = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130136_(Short.MAX_VALUE);
            orderedOps.add(key);
        }
        return new PacketGraphicsReady(pos, gfxOps, orderedOps);
    }

    public static PacketGraphicsReady create(ProcessorTileEntity processor) {
        return new PacketGraphicsReady(processor.m_58899_(), processor.getGfxOps(), processor.getOrderedOps());
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.setClientOrderedGfx(this.gfxOps, this.orderedOps);
            }
        });
    }
}

