/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.grid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridInstance;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ProgramCardInstance {
    private final Map<GridPos, GridInstance> gridInstances = new HashMap<GridPos, GridInstance>();

    public Map<GridPos, GridInstance> getGridInstances() {
        return this.gridInstances;
    }

    private ProgramCardInstance() {
    }

    public static ProgramCardInstance newInstance() {
        return new ProgramCardInstance();
    }

    public static ProgramCardInstance parseInstance(ItemStack card) {
        CompoundTag tagCompound = card.m_41783_();
        if (tagCompound == null) {
            return null;
        }
        ProgramCardInstance instance = new ProgramCardInstance();
        ListTag grid = tagCompound.m_128437_("grid", 10);
        for (Tag inbt : grid) {
            CompoundTag gridElement = (CompoundTag)inbt;
            ProgramCardInstance.parseElement(gridElement, instance);
        }
        return instance;
    }

    private static void parseElement(CompoundTag tag, ProgramCardInstance instance) {
        int x = tag.m_128451_("x");
        int y = tag.m_128451_("y");
        GridInstance gi = GridInstance.readFromNBT(tag);
        if (gi != null) {
            instance.putGridInstance(x, y, gi);
        }
    }

    public void putGridInstance(int x, int y, GridInstance gridInstance) {
        this.gridInstances.put(GridPos.pos(x, y), gridInstance);
    }

    public static ProgramCardInstance readFromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        ProgramCardInstance instance = new ProgramCardInstance();
        for (JsonElement entry : root.getAsJsonArray()) {
            JsonElement posElement = entry.getAsJsonObject().get("pos");
            JsonElement gridElement = entry.getAsJsonObject().get("opcode");
            int x = posElement.getAsJsonObject().get("x").getAsInt();
            int y = posElement.getAsJsonObject().get("y").getAsInt();
            GridInstance gi = GridInstance.readFromJson(gridElement);
            if (gi == null) continue;
            instance.putGridInstance(x, y, gi);
        }
        return instance;
    }

    public String writeToJson() {
        JsonArray array = new JsonArray();
        for (Map.Entry<GridPos, GridInstance> entry : this.gridInstances.entrySet()) {
            GridPos coordinate = entry.getKey();
            GridInstance gridInstance = entry.getValue();
            JsonObject ruleObject = new JsonObject();
            ruleObject.add("pos", this.buildCoordinateElement(coordinate));
            ruleObject.add("opcode", gridInstance.getJsonElement());
            array.add((JsonElement)ruleObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)array);
    }

    private JsonElement buildCoordinateElement(GridPos pos) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("x", (JsonElement)new JsonPrimitive((Number)pos.x()));
        jsonObject.add("y", (JsonElement)new JsonPrimitive((Number)pos.y()));
        return jsonObject;
    }

    public void writeToNBT(ItemStack card) {
        CompoundTag tagCompound = card.m_41784_();
        ListTag grid = new ListTag();
        for (Map.Entry<GridPos, GridInstance> entry : this.gridInstances.entrySet()) {
            GridPos coordinate = entry.getKey();
            int x = coordinate.x();
            int y = coordinate.y();
            GridInstance gridInstance = entry.getValue();
            CompoundTag tag = gridInstance.writeToNBT(x, y);
            grid.add((Object)tag);
        }
        tagCompound.m_128365_("grid", (Tag)grid);
    }
}

