/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class BooleanEditor
extends AbstractParameterEditor {
    private ChoiceLabel label;

    private static Boolean parseBoolSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return "true".equals(t);
    }

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.label = (ChoiceLabel)new ChoiceLabel().choices(new String[]{"*", "true", "false"}).event(newChoice -> callback.valueChanged(this.readValue())).desiredWidth(60);
        constantPanel.children(new Widget[]{this.label});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_BOOLEAN);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)BooleanEditor.parseBoolSafe(this.label.getCurrentChoice()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.label.choice("*");
        } else {
            String choice = value.getValue().toString();
            this.label.choice(choice);
        }
    }
}

