/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record DensityInfluence(DensityFunction base, DensityFunction modifier, DensityFunction influence, double minInfluence, double maxInfluence) implements DensityFunction
{
    public static final KeyDispatchDataCodec<DensityInfluence> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("base").forGetter(DensityInfluence::base), (App)DensityFunction.f_208218_.fieldOf("modifier").forGetter(DensityInfluence::modifier), (App)DensityFunction.f_208218_.fieldOf("influence").forGetter(DensityInfluence::influence), (App)Codec.DOUBLE.optionalFieldOf("min_influence", (Object)-1.0).forGetter(DensityInfluence::minInfluence), (App)Codec.DOUBLE.optionalFieldOf("max_influence", (Object)-1.0).forGetter(DensityInfluence::maxInfluence)).apply((Applicative)instance, DensityInfluence::new)));

    @Nonnull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    public double m_207386_(@Nonnull DensityFunction.FunctionContext context) {
        double influence = this.minInfluence() + this.influence().m_207386_(context) / (this.maxInfluence() - this.minInfluence());
        return this.base().m_207386_(context) + influence * this.modifier().m_207386_(context);
    }

    public void m_207362_(@Nonnull double[] array, @Nonnull DensityFunction.ContextProvider provider) {
        double[] influence = new double[array.length];
        double[] modifier = new double[array.length];
        this.base().m_207362_(array, provider);
        this.influence().m_207362_(influence, provider);
        this.modifier().m_207362_(modifier, provider);
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] + (this.minInfluence() + influence[i] / (this.maxInfluence() - this.minInfluence())) * modifier[i];
        }
    }

    @Nonnull
    public DensityFunction m_207456_(@Nonnull DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new DensityInfluence(this.base().m_207456_(visitor), this.modifier().m_207456_(visitor), this.influence().m_207456_(visitor), this.minInfluence(), this.maxInfluence()));
    }

    public double m_207402_() {
        return this.base().m_207402_() + (this.minInfluence() + this.influence().m_207402_() / (this.maxInfluence() - this.minInfluence())) * this.modifier().m_207402_();
    }

    public double m_207401_() {
        return this.base().m_207401_() + (this.minInfluence() + this.influence().m_207401_() / (this.maxInfluence() - this.minInfluence())) * this.modifier().m_207401_();
    }
}

