/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.resource;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.impl.datagen.resource.PathResource;
import org.moddingx.libx.impl.datagen.resource.VanillaResource;
import org.moddingx.libx.util.lazy.LazyValue;

public class ResourceLocator {
    private static final LazyValue<ResourceLocator> CLIENT_RESOURCES = new LazyValue<ResourceLocator>(() -> new Root(PackType.CLIENT_RESOURCES));
    private static final LazyValue<ResourceLocator> SERVER_DATA = new LazyValue<ResourceLocator>(() -> new Root(PackType.SERVER_DATA));
    private final List<Path> paths;
    @Nullable
    private final String prefix;
    private final List<ResourceLocator> parents;

    public static ResourceLocator root(PackType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PackType.CLIENT_RESOURCES -> CLIENT_RESOURCES.get();
            case PackType.SERVER_DATA -> SERVER_DATA.get();
        };
    }

    public ResourceLocator(List<Path> paths, @Nullable String prefix, List<ResourceLocator> parents) {
        this.paths = List.copyOf(paths);
        if (prefix != null) {
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(1);
            }
        }
        this.prefix = prefix;
        this.parents = List.copyOf(parents);
    }

    @Nullable
    public PackTarget.Resource getResource(ExistingFileHelper fileHelper, ResourceLocation res) {
        for (Path path : this.paths) {
            Path path2 = path.resolve(res.m_135827_()).resolve(res.m_135815_());
            if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
            return new PathResource(path2);
        }
        if (this.prefix != null) {
            ResourceLocation resolved = new ResourceLocation(res.m_135827_(), this.prefix + "/" + res.m_135815_());
            for (ResourceLocator parent : this.parents) {
                PackTarget.Resource resource = parent.getResource(fileHelper, resolved);
                if (resource == null) continue;
                return resource;
            }
        }
        for (ResourceLocator resourceLocator : this.parents) {
            PackTarget.Resource resource = resourceLocator.getResource(fileHelper, res);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static class Root
    extends ResourceLocator {
        private final PackType type;

        public Root(PackType type) {
            super(List.of(), null, List.of());
            this.type = type;
        }

        @Override
        @Nullable
        public PackTarget.Resource getResource(ExistingFileHelper fileHelper, ResourceLocation res) {
            if (!fileHelper.exists(res, this.type)) {
                return null;
            }
            try {
                return new VanillaResource(fileHelper.getResource(res, this.type));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
    }
}

