/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.DatagenSystem;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.RegistryProvider;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistrySet;

public class InternalDataProvider
implements DataProvider {
    private final DatagenSystem system;
    private final DatagenRegistrySet rootRegistries;
    private final List<Entry<RegistryProvider>> registryProviders;
    private final List<Entry<RegistryProvider>> extensionProviders;
    private final List<Entry<DataProvider>> dataProviders;
    private final Map<Class<? extends RegistryProvider>, RegistryProvider> initialisedRegistryProviders;
    private final Map<Class<? extends DataProvider>, DataProvider> initialisedDataProviders;
    private final Set<PackTarget> allTargets;

    public InternalDataProvider(DatagenSystem system, DatagenRegistrySet rootRegistries, List<Entry<RegistryProvider>> registryProviders, List<Entry<RegistryProvider>> extensionProviders, List<Entry<DataProvider>> dataProviders) {
        this.system = system;
        this.rootRegistries = rootRegistries;
        this.registryProviders = List.copyOf(registryProviders);
        this.extensionProviders = List.copyOf(extensionProviders);
        this.dataProviders = new ArrayList<Entry<DataProvider>>(dataProviders);
        this.initialisedRegistryProviders = new HashMap<Class<? extends RegistryProvider>, RegistryProvider>();
        this.initialisedDataProviders = new HashMap<Class<? extends DataProvider>, DataProvider>();
        this.allTargets = Streams.concat((Stream[])new Stream[]{registryProviders.stream().map(Entry::target), extensionProviders.stream().map(Entry::target), dataProviders.stream().map(Entry::target)}).collect(Collectors.toUnmodifiableSet());
    }

    @Nonnull
    public final String m_6055_() {
        return "LibX datagen for " + this.system.mod().modid;
    }

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput output) {
        RegistryProvider provider;
        if (!this.registryProviders.isEmpty()) {
            LibX.logger.info("Stage {}", (Object)DatagenStage.REGISTRY_SETUP);
        }
        this.rootRegistries.transition(DatagenStage.REGISTRY_SETUP);
        for (Entry<RegistryProvider> entry : this.registryProviders) {
            provider = this.initProvider(DatagenStage.REGISTRY_SETUP, entry, this.initialisedRegistryProviders);
            this.runTimed(provider.getName(), DatagenStage.REGISTRY_SETUP, () -> {
                provider.run();
                return null;
            });
        }
        if (!this.extensionProviders.isEmpty()) {
            LibX.logger.info("Stage {}", (Object)DatagenStage.EXTENSION_SETUP);
        }
        this.rootRegistries.transition(DatagenStage.EXTENSION_SETUP);
        for (Entry<RegistryProvider> entry : this.extensionProviders) {
            provider = this.initProvider(DatagenStage.EXTENSION_SETUP, entry, this.initialisedRegistryProviders);
            this.runTimed(provider.getName(), DatagenStage.EXTENSION_SETUP, () -> {
                provider.run();
                return null;
            });
        }
        LibX.logger.info("Stage {}", (Object)DatagenStage.DATAGEN);
        this.rootRegistries.transition(DatagenStage.DATAGEN);
        LibX.logger.info("Start writing registry data");
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (PackTarget target : this.allTargets) {
            ((DatagenRegistrySet)target.registries()).writeElements(target, output);
        }
        stopwatch.stop();
        LibX.logger.info("Writing registry data took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        ArrayList<DataProvider> arrayList = new ArrayList<DataProvider>();
        for (int idx = 0; idx < this.dataProviders.size(); ++idx) {
            arrayList.add(this.initProvider(DatagenStage.DATAGEN, this.dataProviders.get(idx), this.initialisedDataProviders));
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (DataProvider provider2 : arrayList) {
            futures.add(this.runTimed(provider2.m_6055_(), DatagenStage.DATAGEN, () -> provider2.m_213708_(output)));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private <T> T initProvider(DatagenStage stage, Entry<T> entry, Map<Class<? extends T>, T> providerMap) {
        Context ctx = new Context(stage, entry.target());
        T provider = entry.factory().apply(ctx);
        ctx.canQuery = false;
        if (providerMap.containsKey(provider.getClass())) {
            providerMap.put(provider.getClass(), null);
        } else {
            providerMap.put(provider.getClass(), provider);
        }
        return provider;
    }

    private <T> T runTimed(String name, DatagenStage stage, Callable<T> action) {
        T result;
        LibX.logger.info("Starting provider {} in stage {}", (Object)name, (Object)stage);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            result = action.call();
        }
        catch (Exception e) {
            stopwatch.stop();
            LibX.logger.info("{} failed after {} ms", (Object)name, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException(e);
        }
        stopwatch.stop();
        LibX.logger.info("{} finished after {} ms", (Object)name, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    public record Entry<T>(PackTarget target, Function<DatagenContext, T> factory) {
    }

    private class Context
    extends DatagenContext {
        private boolean canQuery;

        protected Context(DatagenStage stage, PackTarget target) {
            super(stage, InternalDataProvider.this.system, target);
            this.canQuery = true;
        }

        @Override
        public <T extends RegistryProvider> T findRegistryProvider(Class<T> cls) {
            if (!this.canQuery) {
                throw new IllegalStateException("Provider has already been set up, can't query additional providers");
            }
            return (T)Objects.requireNonNull(InternalDataProvider.this.initialisedRegistryProviders.get(cls), "Could not lookup provider: " + cls);
        }

        @Override
        public <T extends DataProvider> T findDataProvider(Class<T> cls) {
            if (!this.canQuery) {
                throw new IllegalStateException("Provider has already been set up, can't query additional providers");
            }
            return (T)Objects.requireNonNull(InternalDataProvider.this.initialisedDataProviders.get(cls), "Could not lookup provider: " + cls);
        }

        @Override
        public void addAdditionalProvider(Function<DatagenContext, DataProvider> provider) {
            if (!this.canQuery) {
                throw new IllegalStateException("Provider has already been set up, can't add additional providers");
            }
            InternalDataProvider.this.dataProviders.add(new Entry<DataProvider>(this.target(), provider));
        }
    }
}

