/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;

public abstract class BiomeProviderBase
extends RegistryProviderBase {
    protected BiomeProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " biomes";
    }

    public BiomeBuilder biome(float temperature, float downfall) {
        return new BiomeBuilder(temperature, downfall);
    }

    public BiomeSpecialEffects.Builder effects() {
        return new BiomeEffectsBuilder();
    }

    public MobSpawnSettings.Builder spawns() {
        return new BiomeSpawnsBuilder();
    }

    public BiomeGenerationSettings.Builder generation() {
        return new BiomeGenerationBuilder();
    }

    public class BiomeBuilder {
        private final float temperature;
        private final Biome.BiomeBuilder builder;

        private BiomeBuilder(float temperature, float downfall) {
            this.temperature = temperature;
            this.builder = new Biome.BiomeBuilder();
            this.builder.m_47609_(temperature);
            this.builder.m_47611_(downfall);
            this.builder.m_47599_(Biome.TemperatureModifier.NONE);
            this.effects(BiomeProviderBase.this.effects());
        }

        public BiomeBuilder frozen() {
            this.builder.m_47599_(Biome.TemperatureModifier.FROZEN);
            return this;
        }

        public BiomeBuilder effects(BiomeSpecialEffects.Builder builder) {
            if (!(builder instanceof BiomeEffectsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#effects to create a BiomeSpecialEffects.Builder instance.");
            }
            BiomeEffectsBuilder effectBuilder = (BiomeEffectsBuilder)builder;
            effectBuilder.setDefaultSkyColor(this.temperature);
            this.builder.m_47603_(builder.m_48018_());
            return this;
        }

        public BiomeBuilder mobSpawns(MobSpawnSettings.Builder builder) {
            if (!(builder instanceof BiomeSpawnsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#spawns to create a MobSpawnSettings.Builder instance.");
            }
            this.builder.m_47605_(builder.m_48381_());
            return this;
        }

        public BiomeBuilder generation(BiomeGenerationSettings.PlainBuilder builder) {
            if (!(builder instanceof BiomeGenerationBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#generation to create a BiomeGenerationSettings.Builder instance.");
            }
            this.builder.m_47601_(builder.m_255380_());
            return this;
        }

        public Holder<Biome> build() {
            return BiomeProviderBase.this.registries.writableRegistry(Registries.f_256952_).m_203693_((Object)this.builder.m_47592_());
        }
    }

    private static class BiomeEffectsBuilder
    extends BiomeSpecialEffects.Builder {
        private BiomeEffectsBuilder() {
            this.m_48019_(12638463);
            this.m_48034_(4159204);
            this.m_48037_(329011);
        }

        private void setDefaultSkyColor(float temperature) {
            if (this.f_48008_.isEmpty()) {
                this.m_48040_(OverworldBiomes.m_194843_((float)temperature));
            }
        }
    }

    private static class BiomeSpawnsBuilder
    extends MobSpawnSettings.Builder {
        private BiomeSpawnsBuilder() {
        }
    }

    private class BiomeGenerationBuilder
    extends BiomeGenerationSettings.Builder {
        private BiomeGenerationBuilder() {
            super((HolderGetter)BiomeProviderBase.this.registries.registry(Registries.f_256988_).m_255303_(), (HolderGetter)BiomeProviderBase.this.registries.registry(Registries.f_257003_).m_255303_());
        }
    }
}

