/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.generator.BiomeLayer;

public abstract class BiomeLayerProviderBase
extends RegistryProviderBase {
    protected BiomeLayerProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " biome layers";
    }

    public BiomeLayerBuilder layer() {
        return new BiomeLayerBuilder();
    }

    public class BiomeLayerBuilder {
        private ClimateRangeTarget range = ClimateRangeTarget.Special.FULL_RANGE;
        private DensityFunction density = null;
        private final List<Pair<Climate.ParameterPoint, Holder<Biome>>> biomes = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>();

        private BiomeLayerBuilder() {
        }

        public BiomeLayerBuilder fullRange() {
            this.range = ClimateRangeTarget.Special.FULL_RANGE;
            return this;
        }

        public BiomeLayerBuilder dynamicRange() {
            this.range = ClimateRangeTarget.Special.DYNAMIC;
            return this;
        }

        public BiomeLayerBuilder range(Climate.ParameterPoint range) {
            this.range = new ClimateRangeTarget.Value(range);
            return this;
        }

        public BiomeLayerBuilder baseLayer() {
            this.density = DensityFunctions.m_208263_();
            return this;
        }

        public BiomeLayerBuilder density(DensityFunction density) {
            this.density = density;
            return this;
        }

        public BiomeLayerBuilder density(Holder<DensityFunction> density) {
            this.density = density.m_203376_() == Holder.Kind.DIRECT ? (DensityFunction)density.m_203334_() : new DensityFunctions.HolderHolder(density);
            return this;
        }

        public ClimateBuilder biome(ResourceKey<Biome> biome) {
            return this.biome((Holder<Biome>)BiomeLayerProviderBase.this.holder(biome));
        }

        public ClimateBuilder biome(Holder<Biome> biome) {
            return new ClimateBuilder(this, biome);
        }

        public Holder<BiomeLayer> build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("Empty biome layer.");
            }
            if (this.density == null) {
                throw new IllegalStateException("No density function set.");
            }
            Climate.ParameterList climateData = new Climate.ParameterList(List.copyOf(this.biomes));
            BiomeLayer layer = new BiomeLayer(this.range.build((Climate.ParameterList<Holder<Biome>>)climateData), this.density, (Climate.ParameterList<Holder<Biome>>)climateData);
            return BiomeLayerProviderBase.this.registries.writableRegistry(SandBox.BIOME_LAYER).m_203693_((Object)layer);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ClimateRangeTarget {
        public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> var1);

        public record Value(Climate.ParameterPoint value) implements ClimateRangeTarget
        {
            @Override
            public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> climateData) {
                return this.value();
            }
        }

        public static enum Special implements ClimateRangeTarget
        {
            FULL_RANGE,
            DYNAMIC;


            @Override
            public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> climateData) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case FULL_RANGE -> BiomeLayer.FULL_RANGE;
                    case DYNAMIC -> new Climate.ParameterPoint(Special.ofAll(climateData, Climate.ParameterPoint::f_186863_), Special.ofAll(climateData, Climate.ParameterPoint::f_186864_), Special.ofAll(climateData, Climate.ParameterPoint::f_186865_), Special.ofAll(climateData, Climate.ParameterPoint::f_186866_), Special.ofAll(climateData, Climate.ParameterPoint::f_186867_), Special.ofAll(climateData, Climate.ParameterPoint::f_186868_), 0L);
                };
            }

            private static Climate.Parameter ofAll(Climate.ParameterList<Holder<Biome>> climateData, Function<Climate.ParameterPoint, Climate.Parameter> extractor) {
                List<Climate.Parameter> params = climateData.m_186850_().stream().map(Pair::getFirst).map(extractor).toList();
                long min = params.stream().mapToLong(Climate.Parameter::f_186813_).min().orElse(0L);
                long max = params.stream().mapToLong(Climate.Parameter::f_186814_).max().orElse(0L);
                return new Climate.Parameter(Math.min(min, max), Math.max(min, max));
            }
        }
    }

    public class ClimateBuilder {
        private final BiomeLayerBuilder target;
        private final Holder<Biome> biome;
        @Nullable
        private Climate.Parameter temperature;
        @Nullable
        private Climate.Parameter humidity;
        @Nullable
        private Climate.Parameter continentalness;
        @Nullable
        private Climate.Parameter erosion;
        @Nullable
        private Climate.Parameter depth;
        @Nullable
        private Climate.Parameter weirdness;
        private long offset;

        private ClimateBuilder(BiomeLayerBuilder target, Holder<Biome> biome) {
            this.target = target;
            this.biome = biome;
            this.temperature = null;
            this.humidity = null;
            this.continentalness = null;
            this.erosion = null;
            this.depth = null;
            this.weirdness = null;
            this.offset = 0L;
        }

        public ClimateBuilder fullRange() {
            this.temperature = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            this.humidity = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            this.continentalness = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            this.erosion = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            this.depth = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            this.weirdness = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
            return this;
        }

        public ClimateBuilder temperature(float temperature) {
            return this.temperature(temperature, temperature);
        }

        public ClimateBuilder temperature(float min, float max) {
            return this.temperature(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder temperature(Climate.Parameter temperature) {
            this.temperature = temperature;
            return this;
        }

        public ClimateBuilder humidity(float humidity) {
            return this.humidity(humidity, humidity);
        }

        public ClimateBuilder humidity(float min, float max) {
            return this.humidity(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder humidity(Climate.Parameter humidity) {
            this.humidity = humidity;
            return this;
        }

        public ClimateBuilder continentalness(float continentalness) {
            return this.continentalness(continentalness, continentalness);
        }

        public ClimateBuilder continentalness(float min, float max) {
            return this.continentalness(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder continentalness(Climate.Parameter continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public ClimateBuilder erosion(float erosion) {
            return this.erosion(erosion, erosion);
        }

        public ClimateBuilder erosion(float min, float max) {
            return this.erosion(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder erosion(Climate.Parameter erosion) {
            this.erosion = erosion;
            return this;
        }

        public ClimateBuilder depth(float depth) {
            return this.depth(depth, depth);
        }

        public ClimateBuilder depth(float min, float max) {
            return this.depth(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder depth(Climate.Parameter depth) {
            this.depth = depth;
            return this;
        }

        public ClimateBuilder weirdness(float weirdness) {
            return this.weirdness(weirdness, weirdness);
        }

        public ClimateBuilder weirdness(float min, float max) {
            return this.weirdness(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder weirdness(Climate.Parameter weirdness) {
            this.weirdness = weirdness;
            return this;
        }

        public ClimateBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public BiomeLayerBuilder from(Climate.ParameterPoint climate) {
            this.target.biomes.add((Pair<Climate.ParameterPoint, Holder<Biome>>)Pair.of((Object)climate, this.biome));
            return this.target;
        }

        public BiomeLayerBuilder add() {
            Objects.requireNonNull(this.temperature, "Climate parameter unset: temperature");
            Objects.requireNonNull(this.humidity, "Climate parameter unset: humidity");
            Objects.requireNonNull(this.continentalness, "Climate parameter unset: continentalness");
            Objects.requireNonNull(this.erosion, "Climate parameter unset: erosion");
            Objects.requireNonNull(this.depth, "Climate parameter unset: depth");
            Objects.requireNonNull(this.weirdness, "Climate parameter unset: weirdness");
            this.target.biomes.add((Pair<Climate.ParameterPoint, Holder<Biome>>)Pair.of((Object)new Climate.ParameterPoint(this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, this.offset), this.biome));
            return this.target;
        }
    }
}

