/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.loot.LootBuilders;
import org.moddingx.libx.datagen.provider.loot.LootProviderBase;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.LootFactory;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.SimpleLootFactory;

public abstract class BlockLootProviderBase
extends LootProviderBase<Block> {
    protected BlockLootProviderBase(DatagenContext ctx) {
        super(ctx, "blocks", LootContextParamSets.f_81421_, Registries.f_256747_);
    }

    @Override
    @Nullable
    protected LootTable.Builder defaultBehavior(Block block) {
        if (block.m_49965_().m_61056_().stream().anyMatch(this::needsLootTable)) {
            LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block);
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
            if (block.m_49966_().m_61138_((Property)BlockStateProperties.f_61401_)) {
                pool = pool.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)));
            }
            if (block.m_49966_().m_61138_((Property)BlockStateProperties.f_61391_)) {
                pool = pool.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD)));
            }
            return LootTable.m_79147_().m_79161_(pool);
        }
        return null;
    }

    protected boolean needsLootTable(BlockState state) {
        return !state.m_60795_() && state.m_60819_().m_76188_().m_60734_() != state.m_60734_() && !BuiltInLootTables.f_78712_.equals((Object)state.m_60734_().m_60589_());
    }

    @Override
    public void generateBaseTable(Block block, LootPoolEntryContainer.Builder<?> entry) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry).m_79080_(ExplosionCondition.m_81661_());
        this.customLootTable(block, LootTable.m_79147_().m_79161_(pool));
    }

    @Override
    protected SimpleLootFactory<Block> element() {
        return LootItem::m_79579_;
    }

    @Override
    public void drops(Block block, ItemStack ... drops) {
        this.drops(block, true, drops);
    }

    @Override
    public void drops(Block block, List<LootFactory<Block>> loot) {
        this.drops(block, true, loot);
    }

    public void drops(Block block, boolean silkTouch, ItemStack ... drops) {
        this.drops(block, silkTouch ? this.silk(this.identity()) : this.noSilk(), drops);
    }

    @SafeVarargs
    public final void drops(Block block, boolean silkTouch, LootFactory<Block> ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).toList());
    }

    public void drops(Block block, boolean silkTouch, List<LootFactory<Block>> drops) {
        this.drops(block, silkTouch ? this.silk(this.identity()) : this.noSilk(), drops);
    }

    public void drops(Block block, SilkModifier silkTouch, ItemStack ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).map(this::stack).toList());
    }

    @SafeVarargs
    public final void drops(Block block, SilkModifier silkTouch, LootFactory<Block> ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).toList());
    }

    public void drops(Block block, SilkModifier silkTouch, List<LootFactory<Block>> drops) {
        LootPoolEntryContainer.Builder<?> entry = this.combine(drops).build(block);
        if (silkTouch.modifier != null) {
            LootPoolEntryContainer.Builder silkBuilder = silkTouch.modifier.apply(block, this.element().build(block)).m_79080_(this.silkCondition());
            entry = LootBuilders.alternative(List.of(silkBuilder, entry));
        }
        this.generateBaseTable(block, entry);
    }

    public SilkModifier silk(GenericLootModifier<Block> modifier) {
        return new SilkModifier(modifier);
    }

    public SilkModifier noSilk() {
        return new SilkModifier(null);
    }

    public LootModifier<Block> fortuneOres() {
        return this.modifier((block, entry) -> entry.m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)));
    }

    public LootModifier<Block> fortuneUniform() {
        return this.fortuneUniform(1);
    }

    public LootModifier<Block> fortuneUniform(int multiplier) {
        return this.modifier((block, entry) -> entry.m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)multiplier)));
    }

    public LootModifier<Block> fortuneBinomial(float probability) {
        return this.fortuneBinomial(probability, 0);
    }

    public LootModifier<Block> fortuneBinomial(float probability, int bonus) {
        return this.modifier((block, entry) -> entry.m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)probability, (int)bonus)));
    }

    public LootItemCondition.Builder randomFortune(float baseChance) {
        return this.randomFortune(baseChance, baseChance * 1.1111112f, baseChance * 1.25f, baseChance * 1.6666666f, baseChance * 5.0f);
    }

    public LootItemCondition.Builder randomFortune(float baseChance, float ... levelChances) {
        float[] chances = new float[levelChances.length + 1];
        chances[0] = baseChance;
        System.arraycopy(levelChances, 0, chances, 1, levelChances.length);
        return BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances);
    }

    public MatchToolBuilder matchTool(ItemLike item) {
        return new MatchToolBuilder(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}));
    }

    public MatchToolBuilder matchTool(TagKey<Item> item) {
        return new MatchToolBuilder(ItemPredicate.Builder.m_45068_().m_204145_(item));
    }

    public MatchStateBuilder matchState() {
        return new MatchStateBuilder(StatePropertiesPredicate.Builder.m_67693_());
    }

    public LootItemCondition.Builder silkCondition() {
        ItemPredicate.Builder predicate = ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)));
        return MatchTool.m_81997_((ItemPredicate.Builder)predicate);
    }

    public LootModifier<Block> copyNBT(String ... tags) {
        return this.modifier((block, entry) -> {
            CopyNbtFunction.Builder func = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
            for (String tag : tags) {
                func = func.m_80279_(tag, "BlockEntityTag." + tag);
            }
            return entry.m_79078_((LootItemFunction.Builder)func);
        });
    }

    public LootModifier<Block> copyProperties(Property<?> ... properties) {
        return this.modifier((block, entry) -> {
            CopyBlockState.Builder func = CopyBlockState.m_80062_((Block)block);
            for (Property property : properties) {
                func = func.m_80084_(property);
            }
            return entry.m_79078_((LootItemFunction.Builder)func);
        });
    }

    public static class SilkModifier {
        @Nullable
        public final GenericLootModifier<Block> modifier;

        private SilkModifier(@Nullable GenericLootModifier<Block> modifier) {
            this.modifier = modifier;
        }
    }

    public static class MatchToolBuilder
    implements LootItemCondition.Builder {
        private final ItemPredicate.Builder builder;

        private MatchToolBuilder(ItemPredicate.Builder builder) {
            this.builder = builder;
        }

        @Nonnull
        public LootItemCondition m_6409_() {
            return MatchTool.m_81997_((ItemPredicate.Builder)this.builder).m_6409_();
        }

        public MatchToolBuilder enchantment(Enchantment enchantment) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.m_55386_((int)1));
        }

        public MatchToolBuilder enchantment(Enchantment enchantment, int minLevel) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.m_55386_((int)minLevel));
        }

        public MatchToolBuilder enchantmentExact(Enchantment enchantment, int level) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.m_55371_((int)level));
        }

        private MatchToolBuilder enchantment(Enchantment enchantment, MinMaxBounds.Ints bounds) {
            this.builder.m_45071_(new EnchantmentPredicate(enchantment, bounds));
            return this;
        }

        public MatchToolBuilder nbt(CompoundTag nbt) {
            this.builder.m_45075_(nbt);
            return this;
        }
    }

    public class MatchStateBuilder
    implements GenericLootModifier<Block> {
        private final StatePropertiesPredicate.Builder builder;

        private MatchStateBuilder(StatePropertiesPredicate.Builder builder) {
            this.builder = builder;
        }

        @Override
        public LootPoolEntryContainer.Builder<?> apply(Block item, LootPoolSingletonContainer.Builder<?> entry) {
            return entry.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)item).m_81784_(this.builder));
        }

        @Override
        public SimpleLootFactory<Block> element() {
            return BlockLootProviderBase.this.element();
        }

        public MatchStateBuilder hasProperty(Property<?> property, String value) {
            this.builder.m_67700_(property, value);
            return this;
        }

        public MatchStateBuilder hasProperty(Property<Integer> property, int value) {
            this.builder.m_67694_(property, value);
            return this;
        }

        public MatchStateBuilder hasProperty(Property<Boolean> property, boolean value) {
            this.builder.m_67703_(property, value);
            return this;
        }

        public <T extends Comparable<T> & StringRepresentable> MatchStateBuilder hasProperty(Property<T> property, T value) {
            this.builder.m_67697_(property, value);
            return this;
        }
    }
}

