/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.AnyHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.RegistryProvider;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.datagen.provider.Id;
import org.moddingx.libx.mod.ModX;

public abstract class RegistryProviderBase
implements RegistryProvider {
    protected final ModX mod;
    protected final RegistrySet registries;
    protected final DatagenContext context;

    protected RegistryProviderBase(DatagenContext ctx, DatagenStage requiredStage) {
        this.mod = ctx.mod();
        this.registries = ctx.registries();
        this.context = ctx;
        if (ctx.stage() != requiredStage) {
            throw new IllegalStateException("Invalid stage: Provider '" + this.getName() + "' must run on " + requiredStage + " stage.");
        }
    }

    public final <T> Holder.Reference<T> holder(ResourceKey<T> key) {
        Registry registry = this.registries.registry(ResourceKey.m_135788_((ResourceLocation)key.m_211136_()));
        return (Holder.Reference)registry.m_203636_(key).orElseThrow(() -> new IllegalArgumentException("Unregistered element in registry " + key.m_211136_() + ": " + key.m_135782_()));
    }

    public final <T> Holder.Reference<T> holder(ResourceKey<? extends Registry<T>> registryKey, T value) {
        Registry registry = this.registries.registry(registryKey);
        return registry.m_7854_(value).map(this::holder).orElseThrow(() -> new IllegalArgumentException("Unregistered element in registry " + registryKey.m_135782_() + ": " + value));
    }

    @SafeVarargs
    public final <T> HolderSet<T> set(Holder<T> ... elements) {
        return HolderSet.m_205809_(elements);
    }

    public final <T> HolderSet<T> set(TagKey<T> tag) {
        Registry registry = this.registries.registry(tag.f_203867_());
        return registry.m_203561_(tag);
    }

    public final <T> HolderSet<T> any(ResourceKey<? extends Registry<T>> registryKey) {
        return new AnyHolderSet(this.registries.registry(registryKey).m_255303_());
    }

    public final <T> HolderSet<T> not(TagKey<T> tag) {
        return new NotHolderSet(this.registries.registry(tag.f_203867_()).m_255303_(), this.set(tag));
    }

    public final <T> HolderSet<T> not(ResourceKey<? extends Registry<T>> registryKey, HolderSet<T> set) {
        return new NotHolderSet(this.registries.registry(registryKey).m_255303_(), set);
    }

    public final <T> HolderSet<T> and(TagKey<T> a, TagKey<T> b) {
        return this.and(this.set(a), this.set(b));
    }

    public final <T> HolderSet<T> and(TagKey<T> a, HolderSet<T> b) {
        return this.and(this.set(a), b);
    }

    public final <T> HolderSet<T> and(HolderSet<T> a, TagKey<T> b) {
        return this.and(a, this.set(b));
    }

    @SafeVarargs
    public final <T> HolderSet<T> and(HolderSet<T> ... sets) {
        return new AndHolderSet(List.of(sets));
    }

    public final <T> HolderSet<T> or(TagKey<T> a, TagKey<T> b) {
        return this.and(this.set(a), this.set(b));
    }

    public final <T> HolderSet<T> or(TagKey<T> a, HolderSet<T> b) {
        return this.and(this.set(a), b);
    }

    public final <T> HolderSet<T> or(HolderSet<T> a, TagKey<T> b) {
        return this.and(a, this.set(b));
    }

    @SafeVarargs
    public final <T> HolderSet<T> or(HolderSet<T> ... sets) {
        return new OrHolderSet(List.of(sets));
    }

    @Override
    public void run() {
        try {
            for (Field field : this.getClass().getFields()) {
                if (field.getDeclaringClass() != this.getClass() || !Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !Holder.class.isAssignableFrom(field.getType())) continue;
                Holder value = (Holder)field.get(this);
                if (value instanceof Holder.Reference) {
                    String id;
                    Holder.Reference ref = (Holder.Reference)value;
                    if (ref.getType() == Holder.Reference.Type.INTRUSIVE && !ref.m_203633_()) {
                        ResourceKey registryKey = this.registries.findRegistryFor(ref);
                        if (registryKey == null) {
                            throw new IllegalStateException("Can't infer target registry for " + field.getName() + " in '" + this.getName() + "'. Was the holder created properly?");
                        }
                        Id idObj = field.getAnnotation(Id.class);
                        if (idObj != null) {
                            id = new ResourceLocation(idObj.namespace().isEmpty() ? this.mod.modid : idObj.namespace(), idObj.value());
                        } else {
                            StringBuilder sb = new StringBuilder();
                            for (char chr : field.getName().toCharArray()) {
                                if (Character.isUpperCase(chr)) {
                                    sb.append('_');
                                }
                                sb.append(Character.toLowerCase(chr));
                            }
                            id = new ResourceLocation(this.mod.modid, sb.toString());
                        }
                        this.registries.writableRegistry(registryKey).m_255290_(ResourceKey.m_135785_(registryKey, (ResourceLocation)id), ref.m_203334_(), Lifecycle.stable());
                        continue;
                    }
                    if (field.getAnnotation(Id.class) == null) continue;
                    Id idObj = field.getAnnotation(Id.class);
                    id = (idObj.namespace().isEmpty() ? this.mod.modid : idObj.namespace()) + ":" + idObj.value();
                    LibX.logger.warn("Skipping bound holder " + field.getName() + " with explicit id " + id + " in '" + this.getName() + "'");
                    continue;
                }
                LibX.logger.warn("Skipping direct holder in '" + this.getName() + "' (from " + field.getName() + ")");
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to register element for provider '" + this.getName() + "'", e);
        }
    }
}

