/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.creativetab;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.GameMasterBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.moddingx.libx.creativetab.CreativeTabItemProvider;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.mod.ModX;

public abstract class CreativeTabX {
    private static final Comparator<Item> REGISTRY_ORDER = Comparator.comparing(item -> {
        Integer n;
        IForgeRegistry patt1092$temp = ForgeRegistries.ITEMS;
        if (patt1092$temp instanceof ForgeRegistry) {
            ForgeRegistry reg = (ForgeRegistry)patt1092$temp;
            n = reg.getID(item);
        } else {
            n = 0x7FFFFFFE;
        }
        return n;
    });
    protected final ModX mod;
    protected final ResourceLocation id;
    private CreativeModeTab tab;

    protected CreativeTabX(ModX mod) {
        this(mod, "tab");
    }

    protected CreativeTabX(ModX mod, String name) {
        this.mod = mod;
        this.id = mod.resource(name);
        ModInternal.get(mod).modEventBus().addListener(this::registerCreativeTab);
    }

    public CreativeModeTab tab() {
        if (this.tab == null) {
            throw new IllegalArgumentException("Creative tab " + this.id + " has not yet been created.");
        }
        return this.tab;
    }

    protected void buildTab(CreativeModeTab.Builder builder) {
        builder.m_257941_((Component)Component.m_237115_((String)("itemGroup." + this.id.m_135827_() + (String)("tab".equals(this.id.m_135815_()) ? "" : "." + this.id.m_135815_()))));
    }

    protected abstract void addItems(TabContext var1);

    protected void addModItems(TabContext ctx) {
        this.addModItems(ctx, REGISTRY_ORDER);
    }

    protected void addModItems(TabContext ctx, Comparator<Item> order) {
        this.addModItems(ctx, order, item -> ctx.context().f_268429_() || !(item instanceof GameMasterBlockItem));
    }

    protected void addModItems(TabContext ctx, Predicate<Item> items) {
        this.addModItems(ctx, REGISTRY_ORDER, items);
    }

    protected void addModItems(TabContext ctx, Comparator<Item> order, Predicate<Item> items) {
        this.addModItemStacks(ctx, order, item -> items.test((Item)item) ? this.itemStream((Item)item) : Stream.empty());
    }

    protected void addModItemStacks(TabContext ctx, Function<Item, Stream<ItemStack>> stacks) {
        this.addModItemStacks(ctx, REGISTRY_ORDER, stacks);
    }

    protected void addModItemStacks(TabContext ctx, Comparator<Item> order, Function<Item, Stream<ItemStack>> stacks) {
        ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).map(Map.Entry::getValue).filter(item -> item.m_245993_(ctx.features())).sorted(order).flatMap(stacks).forEach(stack -> ctx.output().m_246342_(stack));
    }

    private void registerCreativeTab(RegisterEvent event) {
        event.register(Registries.f_279569_, reg -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder();
            this.buildTab(builder);
            builder.m_257501_((context, output) -> this.addItems(new TabContext(context, context.f_268709_(), output)));
            this.tab = builder.m_257652_();
            reg.register(this.id, (Object)this.tab);
        });
    }

    private Stream<ItemStack> itemStream(Item item) {
        if (item instanceof CreativeTabItemProvider) {
            CreativeTabItemProvider provider = (CreativeTabItemProvider)item;
            return provider.makeCreativeTabStacks();
        }
        return Stream.of(new ItemStack((ItemLike)item));
    }

    public record TabContext(CreativeModeTab.ItemDisplayParameters context, FeatureFlagSet features, CreativeModeTab.Output output) {
    }
}

