/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.recipes.FluidFoodValueRecipe;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.IFoodInfo;
import com.teammoeg.caupona.util.SpicedFoodInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StewInfo
extends SpicedFoodInfo
implements IFoodInfo {
    public List<FloatemStack> stacks;
    public List<MobEffectInstance> effects;
    public List<Pair<MobEffectInstance, Float>> foodeffect = new ArrayList<Pair<MobEffectInstance, Float>>();
    public int healing;
    public float saturation;
    public float shrinkedFluid = 0.0f;
    public ResourceLocation base;

    public StewInfo(List<FloatemStack> stacks, List<MobEffectInstance> effects, int healing, float saturation, ResourceLocation base) {
        this.stacks = stacks;
        this.effects = effects;
        this.healing = healing;
        this.saturation = saturation;
        this.base = base;
    }

    public StewInfo() {
        this(new ArrayList<FloatemStack>(), new ArrayList<MobEffectInstance>(), 0, 0.0f, new ResourceLocation("minecraft:water"));
    }

    public static List<FloatemStack> getStacks(CompoundTag nbt) {
        return nbt.m_128437_("items", 10).stream().map(e -> (CompoundTag)e).map(FloatemStack::new).collect(Collectors.toList());
    }

    public float getDensity() {
        return this.stacks.stream().map(FloatemStack::getCount).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public boolean canAlwaysEat() {
        return this.healing <= 1 || (double)this.getDensity() <= 0.5;
    }

    public StewInfo(CompoundTag nbt) {
        super(nbt);
        this.stacks = nbt.m_128437_("items", 10).stream().map(e -> (CompoundTag)e).map(FloatemStack::new).collect(Collectors.toList());
        this.effects = nbt.m_128437_("effects", 10).stream().map(e -> (CompoundTag)e).map(MobEffectInstance::m_19560_).collect(Collectors.toList());
        this.healing = nbt.m_128451_("heal");
        this.saturation = nbt.m_128457_("sat");
        this.foodeffect = nbt.m_128437_("feffects", 10).stream().map(e -> (CompoundTag)e).map(e -> new Pair((Object)MobEffectInstance.m_19560_((CompoundTag)e.m_128469_("effect")), (Object)Float.valueOf(e.m_128457_("chance")))).collect(Collectors.toList());
        this.base = new ResourceLocation(nbt.m_128461_("base"));
        this.shrinkedFluid = nbt.m_128457_("afluid");
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty() && this.effects.isEmpty();
    }

    public boolean canMerge(StewInfo f, float cparts, float oparts) {
        return (this.getDensity() * cparts + f.getDensity() * oparts) / (cparts + oparts) <= 3.0f;
    }

    public boolean merge(StewInfo f, float cparts, float oparts) {
        if (!this.canMerge(f, cparts, oparts)) {
            return false;
        }
        this.forceMerge(f, cparts, oparts);
        return true;
    }

    public void forceMerge(StewInfo f, float cparts, float oparts) {
        boolean added;
        for (MobEffectInstance mobEffectInstance : f.effects) {
            added = false;
            for (MobEffectInstance mobEffectInstance2 : this.effects) {
                if (!StewInfo.isEffectEquals(mobEffectInstance2, mobEffectInstance)) continue;
                mobEffectInstance2.f_19503_ = (int)((float)mobEffectInstance2.f_19503_ + (float)mobEffectInstance.f_19503_ * oparts / cparts);
                added = true;
                break;
            }
            if (added || this.effects.size() >= 3) continue;
            MobEffectInstance copy = new MobEffectInstance(mobEffectInstance);
            copy.f_19503_ = (int)((float)copy.f_19503_ * oparts / cparts);
            this.effects.add(copy);
        }
        for (Pair pair : f.foodeffect) {
            added = false;
            for (Pair pair2 : this.foodeffect) {
                if (pair.getSecond() != pair2.getSecond() || !StewInfo.isEffectEquals((MobEffectInstance)pair2.getFirst(), (MobEffectInstance)pair.getFirst())) continue;
                ((MobEffectInstance)pair2.getFirst()).f_19503_ = (int)((float)((MobEffectInstance)pair2.getFirst()).f_19503_ + (float)((MobEffectInstance)pair.getFirst()).f_19503_ * oparts / cparts);
                added = true;
                break;
            }
            if (added) continue;
            this.foodeffect.add((Pair<MobEffectInstance, Float>)pair);
        }
        this.shrinkedFluid += f.shrinkedFluid * oparts / cparts;
        for (FloatemStack floatemStack : f.stacks) {
            this.addItem(new FloatemStack(floatemStack.getStack(), floatemStack.count * oparts / cparts));
        }
        this.completeAll();
    }

    public void completeAll() {
        this.clearSpice();
        this.completeData();
        this.completeEffects();
    }

    public void completeData() {
        this.stacks.sort(Comparator.comparingInt(e -> Item.m_41393_((Item)e.stack.m_41720_())));
        this.foodeffect.sort(Comparator.comparingInt(e -> MobEffect.m_19459_((MobEffect)((MobEffectInstance)e.getFirst()).m_19544_())).thenComparing(Pair::getSecond));
    }

    public void completeEffects() {
        this.effects.sort(Comparator.comparingInt(x -> MobEffect.m_19459_((MobEffect)x.m_19544_())).thenComparingInt(e -> e.m_19557_()));
    }

    public static boolean isEffectEquals(MobEffectInstance t1, MobEffectInstance t2) {
        return t1.m_19544_() == t2.m_19544_() && t1.m_19564_() == t2.m_19564_();
    }

    public void addEffect(MobEffectInstance eff, float parts) {
        for (MobEffectInstance oes : this.effects) {
            if (!StewInfo.isEffectEquals(oes, eff)) continue;
            oes.f_19503_ = Math.max(oes.f_19503_, (int)Math.min((float)oes.f_19503_ + (float)eff.f_19503_ / parts, (float)eff.f_19503_ * 2.0f));
            return;
        }
        if (this.effects.size() < 3) {
            MobEffectInstance copy = new MobEffectInstance(eff);
            copy.f_19503_ = (int)((float)copy.f_19503_ / parts);
            this.effects.add(copy);
        }
    }

    public void recalculateHAS() {
        this.foodeffect.clear();
        float nh = 0.0f;
        float ns = 0.0f;
        for (FloatemStack fs : this.stacks) {
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(fs.getItem());
            if (fvr != null) {
                nh += (float)fvr.heal * fs.count;
                ns += fvr.sat * fs.count * (float)fvr.heal;
                if (fvr.effects == null) continue;
                this.foodeffect.addAll(fvr.effects);
                continue;
            }
            FoodProperties f = fs.getStack().getFoodProperties(null);
            if (f == null) continue;
            nh += fs.count * (float)f.m_38744_();
            ns += fs.count * f.m_38745_() * (float)f.m_38744_();
            this.foodeffect.addAll(f.m_38749_());
        }
        FluidFoodValueRecipe ffvr = FluidFoodValueRecipe.recipes.get(this.base);
        if (ffvr != null) {
            nh += (float)ffvr.heal * (1.0f + this.shrinkedFluid);
            ns += ffvr.sat * (1.0f + this.shrinkedFluid);
        }
        float dense = this.getDensity();
        int conv = (int)((double)Mth.m_14036_((float)((dense - 1.0f) / 2.0f), (float)0.0f, (float)1.0f) * 0.3 * (double)nh);
        this.healing = (int)Math.ceil(nh - (float)conv);
        this.saturation = this.healing > 0 ? Math.max(0.7f, (ns += (float)conv / 2.0f) / (float)this.healing) : 0.0f;
    }

    public void adjustParts(float oparts, float parts) {
        if (oparts == parts) {
            return;
        }
        for (FloatemStack floatemStack : this.stacks) {
            floatemStack.setCount(floatemStack.getCount() * oparts / parts);
        }
        for (MobEffectInstance mobEffectInstance : this.effects) {
            mobEffectInstance.f_19503_ = (int)((float)mobEffectInstance.f_19503_ * oparts / parts);
        }
        for (Pair pair : this.foodeffect) {
            ((MobEffectInstance)pair.getFirst()).f_19503_ = (int)((float)((MobEffectInstance)pair.getFirst()).f_19503_ * oparts / parts);
        }
        float delta = 0.0f;
        if (oparts > parts) {
            delta = oparts - parts;
        }
        this.clearSpice();
        this.shrinkedFluid = (this.shrinkedFluid * oparts + delta) / parts;
        this.healing = (int)((float)this.healing * oparts / parts);
        this.saturation = this.saturation * oparts / parts;
    }

    public StewInfo(ResourceLocation base) {
        this(new ArrayList<FloatemStack>(), new ArrayList<MobEffectInstance>(), 0, 0.0f, base);
    }

    public static String getRegName(CompoundTag nbt) {
        return nbt.m_128461_("base");
    }

    public void addItem(ItemStack is, float parts) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is)) continue;
            i.count += (float)is.m_41613_() / parts;
            return;
        }
        this.stacks.add(new FloatemStack(is.m_41777_(), (float)is.m_41613_() / parts));
    }

    public void addItem(FloatemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is.getStack())) continue;
            i.count += is.count;
            return;
        }
        this.stacks.add(is);
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        nbt.m_128365_("items", (Tag)SerializeUtil.toNBTList(this.stacks, FloatemStack::serializeNBT));
        nbt.m_128365_("effects", (Tag)SerializeUtil.toNBTList(this.effects, e -> e.m_19555_(new CompoundTag())));
        nbt.m_128365_("feffects", (Tag)SerializeUtil.toNBTList(this.foodeffect, e -> {
            CompoundTag cnbt = new CompoundTag();
            cnbt.m_128365_("effect", (Tag)((MobEffectInstance)e.getFirst()).m_19555_(new CompoundTag()));
            cnbt.m_128350_("chance", ((Float)e.getSecond()).floatValue());
            return cnbt;
        }));
        nbt.m_128405_("heal", this.healing);
        nbt.m_128350_("sat", this.saturation);
        nbt.m_128359_("base", this.base.toString());
        nbt.m_128350_("afluid", this.shrinkedFluid);
    }

    @Override
    public List<FloatemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public int getHealing() {
        return this.healing;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public FoodProperties getFood() {
        FoodProperties.Builder b = new FoodProperties.Builder();
        for (MobEffectInstance mobEffectInstance : this.effects) {
            if (mobEffectInstance == null) continue;
            b.m_38762_(mobEffectInstance, 1.0f);
        }
        if (this.spice != null) {
            b.effect(() -> new MobEffectInstance(this.spice), 1.0f);
        }
        for (Pair pair : this.foodeffect) {
            b.effect(() -> new MobEffectInstance((MobEffectInstance)ef.getFirst()), ((Float)pair.getSecond()).floatValue());
        }
        b.m_38760_(this.healing);
        if (Float.isNaN(this.saturation)) {
            b.m_38758_(0.0f);
        } else {
            b.m_38758_(this.saturation);
        }
        if (this.canAlwaysEat()) {
            b.m_38765_();
        }
        return b.m_38767_();
    }

    @Override
    public List<Pair<Supplier<MobEffectInstance>, Float>> getEffects() {
        ArrayList<Pair<Supplier<MobEffectInstance>, Float>> li = new ArrayList<Pair<Supplier<MobEffectInstance>, Float>>();
        for (MobEffectInstance mobEffectInstance : this.effects) {
            if (mobEffectInstance == null) continue;
            li.add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(() -> new MobEffectInstance(eff), (Object)Float.valueOf(1.0f)));
        }
        if (this.spice != null) {
            li.add(Pair.of(() -> new MobEffectInstance(this.spice), (Object)Float.valueOf(1.0f)));
        }
        for (Pair pair : this.foodeffect) {
            li.add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(() -> new MobEffectInstance((MobEffectInstance)ef.getFirst()), (Object)((Float)pair.getSecond())));
        }
        return li;
    }
}

