/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FluidFoodValueRecipe
extends IDataRecipe {
    public static Map<ResourceLocation, FluidFoodValueRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public int heal;
    public float sat;
    public List<Pair<MobEffectInstance, Float>> effects;
    private ItemStack repersent;
    public int parts;
    public ResourceLocation f;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public FluidFoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack repersent, int parts, Fluid f) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.repersent = repersent;
        this.parts = parts;
        this.f = Utils.getRegistryName(f);
    }

    public FluidFoodValueRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        ItemStack[] i;
        this.heal = jo.get("heal").getAsInt();
        this.sat = jo.get("sat").getAsFloat();
        this.f = new ResourceLocation(jo.get("fluid").getAsString());
        this.parts = jo.has("parts") ? jo.get("parts").getAsInt() : 1;
        this.effects = SerializeUtil.parseJsonList(jo.get("effects"), x -> {
            MobEffect eff;
            int amplifier = 0;
            if (x.has("level")) {
                amplifier = x.get("level").getAsInt();
            }
            int duration = 0;
            if (x.has("time")) {
                duration = x.get("time").getAsInt();
            }
            if ((eff = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(x.get("effect").getAsString()))) == null) {
                return null;
            }
            MobEffectInstance effect = new MobEffectInstance(eff, duration, amplifier);
            float f = 1.0f;
            if (x.has("chance")) {
                f = x.get("chance").getAsInt();
            }
            return new Pair((Object)effect, (Object)Float.valueOf(f));
        });
        if (this.effects != null) {
            this.effects.removeIf(e -> e == null);
        }
        if (jo.has("item") && (i = Ingredient.m_43917_((JsonElement)jo.get("item")).m_43908_()).length > 0) {
            this.repersent = i[0];
        }
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        json.addProperty("heal", (Number)this.heal);
        json.addProperty("sat", (Number)Float.valueOf(this.sat));
        json.addProperty("parts", (Number)this.parts);
        json.addProperty("fluid", this.f.toString());
        if (this.effects != null && !this.effects.isEmpty()) {
            json.add("effects", (JsonElement)SerializeUtil.toJsonList(this.effects, x -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("level", (Number)((MobEffectInstance)x.getFirst()).m_19564_());
                jo.addProperty("time", (Number)((MobEffectInstance)x.getFirst()).m_19557_());
                jo.addProperty("effect", Utils.getRegistryName(((MobEffectInstance)x.getFirst()).m_19544_()).toString());
                jo.addProperty("chance", (Number)x.getSecond());
                return jo;
            }));
        }
        if (this.repersent != null) {
            json.add("item", Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.repersent}).m_43942_());
        }
    }

    public FluidFoodValueRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.heal = data.m_130242_();
        this.sat = data.readFloat();
        this.parts = data.m_130242_();
        this.f = data.m_130281_();
        this.effects = SerializeUtil.readList(data, d -> new Pair((Object)MobEffectInstance.m_19560_((CompoundTag)d.m_130260_()), (Object)Float.valueOf(d.readFloat())));
        this.repersent = SerializeUtil.readOptional(data, d -> ItemStack.m_41712_((CompoundTag)d.m_130260_())).orElse(null);
    }

    public FluidFoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack repersent, int parts, ResourceLocation f) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.repersent = repersent;
        this.parts = parts;
        this.f = f;
    }

    public void write(FriendlyByteBuf data) {
        data.m_130130_(this.heal);
        data.writeFloat(this.sat);
        data.m_130130_(this.parts);
        data.m_130085_(this.f);
        SerializeUtil.writeList2(data, this.effects, (d, e) -> {
            CompoundTag nc = new CompoundTag();
            ((MobEffectInstance)e.getFirst()).m_19555_(nc);
            d.m_130079_(nc);
            d.writeFloat(((Float)e.getSecond()).floatValue());
        });
        SerializeUtil.writeOptional(data, this.repersent, (d, e) -> e.m_130079_(d.serializeNBT()));
    }

    public ItemStack getRepersent() {
        return this.repersent;
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? repersent.m_41777_() : null;
    }
}

