/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.util.Utils;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BoilingRecipe
extends IDataRecipe {
    public static Map<Fluid, BoilingRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public Fluid before;
    public Fluid after;
    public int time;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public BoilingRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.before = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("from").getAsString()));
        this.after = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("to").getAsString()));
        this.time = jo.get("time").getAsInt();
        if (this.before == Fluids.f_76191_ || this.after == Fluids.f_76191_) {
            throw new InvalidRecipeException();
        }
    }

    public BoilingRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.before = (Fluid)data.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.after = (Fluid)data.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.time = data.m_130242_();
    }

    public BoilingRecipe(ResourceLocation id, Fluid before, Fluid after, int time) {
        super(id);
        this.before = before;
        this.after = after;
        this.time = time;
    }

    public void write(FriendlyByteBuf data) {
        data.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.before);
        data.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.after);
        data.m_130130_(this.time);
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        json.addProperty("from", Utils.getRegistryName(this.before).toString());
        json.addProperty("to", Utils.getRegistryName(this.after).toString());
        json.addProperty("time", (Number)this.time);
    }

    public FluidStack handle(FluidStack org) {
        FluidStack fs = new FluidStack(this.after, org.getAmount());
        if (org.hasTag()) {
            fs.setTag(org.getTag());
        }
        return fs;
    }
}

