/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPRecipeSerializer<T extends IDataRecipe>
implements RecipeSerializer<T> {
    BiFunction<ResourceLocation, JsonObject, T> jsfactory;
    BiFunction<ResourceLocation, FriendlyByteBuf, T> pkfactory;
    BiConsumer<T, FriendlyByteBuf> writer;
    static final Logger logger = LogManager.getLogger((String)"caupona recipe serialize");

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        try {
            return (T)((IDataRecipe)this.jsfactory.apply(recipeId, json));
        }
        catch (InvalidRecipeException e) {
            return null;
        }
    }

    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        return (T)((IDataRecipe)this.pkfactory.apply(recipeId, buffer));
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        this.writer.accept(recipe, buffer);
    }

    public CPRecipeSerializer(BiFunction<ResourceLocation, JsonObject, T> jsfactory, BiFunction<ResourceLocation, FriendlyByteBuf, T> pkfactory, BiConsumer<T, FriendlyByteBuf> writer) {
        this.jsfactory = jsfactory;
        this.pkfactory = pkfactory;
        this.writer = writer;
    }
}

