/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.compat.jei.category.BaseCallback;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class DoliumRestingCategory
implements IRecipeCategory<DoliumRecipe> {
    public static RecipeType<DoliumRecipe> TYPE = RecipeType.create((String)"caupona", (String)"dolium_resting", DoliumRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public DoliumRestingCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CPBlocks.dolium.get(0)));
        ResourceLocation guiMain = new ResourceLocation("caupona", "textures/gui/jei/maximum_resting.png");
        this.BACKGROUND = guiHelper.createDrawable(guiMain, 0, 0, 127, 63);
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.resting.title");
    }

    public void draw(DoliumRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        String burnTime = String.valueOf((float)((Integer)CPConfig.COMMON.staticTime.get()).intValue() / 20.0f) + "s";
        stack.m_280488_(Minecraft.m_91087_().f_91062_, burnTime, 100, 55, 0xFFFFFF);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    private static List<ItemStack> unpack(Pair<Ingredient, Integer> ps) {
        ArrayList<ItemStack> sl = new ArrayList<ItemStack>();
        for (ItemStack is : ((Ingredient)ps.getFirst()).m_43908_()) {
            sl.add(ItemHandlerHelper.copyStackWithSize((ItemStack)is, (int)((Integer)ps.getSecond() > 0 ? (Integer)ps.getSecond() : 1)));
        }
        return sl;
    }

    private static List<ItemStack> unpack(Ingredient ps) {
        if (ps instanceof AbstractIngredient) {
            return Arrays.asList(ps.m_43908_());
        }
        ArrayList<ItemStack> sl = new ArrayList<ItemStack>();
        for (ItemStack is : ps.m_43908_()) {
            if (is.m_41763_()) {
                for (int i = 0; i <= is.m_41776_(); ++i) {
                    ItemStack iss = is.m_41777_();
                    iss.m_41721_(i);
                    sl.add(iss);
                }
                continue;
            }
            sl.add(is);
        }
        return sl;
    }

    private static RecipeIngredientRole type(Pair<Ingredient, Integer> ps) {
        return (Integer)ps.getSecond() == 0 ? RecipeIngredientRole.CATALYST : RecipeIngredientRole.INPUT;
    }

    private static CatalistCallback cb(Pair<Ingredient, Integer> ps) {
        return new CatalistCallback((Integer)ps.getSecond());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DoliumRecipe recipe, IFocusGroup focuses) {
        if (recipe.items.size() > 0) {
            ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(recipe.items.get(0)), 4, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(recipe.items.get(0)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(recipe.items.get(0)));
            if (recipe.items.size() > 1) {
                ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(recipe.items.get(1)), 4, 24).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(recipe.items.get(1)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(recipe.items.get(1)));
                if (recipe.items.size() > 2) {
                    ((IRecipeSlotBuilder)builder.addSlot(DoliumRestingCategory.type(recipe.items.get(2)), 4, 42).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(recipe.items.get(2)))).addTooltipCallback((IRecipeSlotTooltipCallback)DoliumRestingCategory.cb(recipe.items.get(2)));
                }
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 24).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.output);
        if (recipe.extra != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 89, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DoliumRestingCategory.unpack(recipe.extra));
        }
        if (recipe.fluid != Fluids.f_76191_) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 9).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.fluid, recipe.amount))).setFluidRenderer(1250L, false, 16, 46).addTooltipCallback((IRecipeSlotTooltipCallback)new BaseCallback(recipe.base, recipe.density));
        }
    }

    public RecipeType<DoliumRecipe> getRecipeType() {
        return TYPE;
    }

    private static class CatalistCallback
    implements IRecipeSlotTooltipCallback {
        int cnt;

        public CatalistCallback(int cnt) {
            this.cnt = cnt;
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            if (this.cnt == 0) {
                tooltip.add((Component)Utils.translate("gui.jei.category.caupona.catalyst"));
            }
        }
    }
}

