/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.client.gui.DoliumScreen;
import com.teammoeg.caupona.client.gui.KitchenStoveScreen;
import com.teammoeg.caupona.client.gui.PanScreen;
import com.teammoeg.caupona.client.gui.PortableBrazierScreen;
import com.teammoeg.caupona.client.gui.StewPotScreen;
import com.teammoeg.caupona.compat.jei.category.BoilingCategory;
import com.teammoeg.caupona.compat.jei.category.BowlEmptyCategory;
import com.teammoeg.caupona.compat.jei.category.BowlFillCategory;
import com.teammoeg.caupona.compat.jei.category.BrazierCategory;
import com.teammoeg.caupona.compat.jei.category.DoliumRestingCategory;
import com.teammoeg.caupona.compat.jei.category.FryingCategory;
import com.teammoeg.caupona.compat.jei.category.IConditionalCategory;
import com.teammoeg.caupona.compat.jei.category.PotCategory;
import com.teammoeg.caupona.compat.jei.category.PotRestingCategory;
import com.teammoeg.caupona.compat.jei.category.StewCookingCategory;
import com.teammoeg.caupona.data.recipes.AspicMeltingRecipe;
import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("caupona", "jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CPItems.pbrazier.get()), new RecipeType[]{BrazierCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CPBlocks.STEW_POT.get()), new RecipeType[]{PotCategory.TYPE, BoilingCategory.TYPE, PotRestingCategory.TYPE, StewCookingCategory.TYPE});
        for (Block bl : CPBlocks.dolium) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)bl), new RecipeType[]{DoliumRestingCategory.TYPE, PotRestingCategory.TYPE});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CPBlocks.STONE_PAN.get()), new RecipeType[]{FryingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CPBlocks.COPPER_PAN.get()), new RecipeType[]{FryingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CPBlocks.IRON_PAN.get()), new RecipeType[]{FryingCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(BrazierCategory.TYPE, new ArrayList<AspicMeltingRecipe>(AspicMeltingRecipe.recipes));
        registration.addRecipes(PotCategory.TYPE, new ArrayList<AspicMeltingRecipe>(AspicMeltingRecipe.recipes));
        registration.addRecipes(BoilingCategory.TYPE, new ArrayList<BoilingRecipe>(BoilingRecipe.recipes.values()));
        registration.addRecipes(BowlEmptyCategory.TYPE, new ArrayList<BowlContainingRecipe>(BowlContainingRecipe.recipes.values()));
        registration.addRecipes(BowlFillCategory.TYPE, new ArrayList<BowlContainingRecipe>(BowlContainingRecipe.recipes.values()));
        registration.addRecipes(DoliumRestingCategory.TYPE, new ArrayList<DoliumRecipe>(DoliumRecipe.recipes));
        registration.addRecipes(StewCookingCategory.TYPE, new ArrayList<StewCookingRecipe>(StewCookingRecipe.sorted));
        registration.addRecipes(FryingCategory.TYPE, new ArrayList<SauteedRecipe>(SauteedRecipe.sorted));
        registration.addRecipes(PotRestingCategory.TYPE, DoliumRecipe.recipes.stream().filter(e -> e.items.size() == 0).collect(Collectors.toList()));
        registration.addItemStackInfo(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("caupona", "leaden_walnut"))), new Component[]{Utils.translate("gui.jei.caupona.info.leaden_walnut")});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        IConditionalCategory.init(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{new BrazierCategory(guiHelper), new PotCategory(guiHelper), new BoilingCategory(guiHelper), new BowlEmptyCategory(guiHelper), new BowlFillCategory(guiHelper), new DoliumRestingCategory(guiHelper), new PotRestingCategory(guiHelper), new StewCookingCategory(guiHelper), new FryingCategory(guiHelper)});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addGuiContainerHandler(PortableBrazierScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<PortableBrazierScreen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(PortableBrazierScreen containerScreen, double mouseX, double mouseY) {
                IGuiClickableArea clickableArea1 = IGuiClickableArea.createBasic((int)60, (int)11, (int)14, (int)16, (RecipeType[])new RecipeType[]{BrazierCategory.TYPE});
                IGuiClickableArea clickableArea2 = IGuiClickableArea.createBasic((int)90, (int)11, (int)14, (int)16, (RecipeType[])new RecipeType[]{BrazierCategory.TYPE});
                return List.of(clickableArea1, clickableArea2);
            }
        });
        registry.addRecipeClickArea(DoliumScreen.class, 118, 32, 10, 25, new RecipeType[]{DoliumRestingCategory.TYPE});
        registry.addRecipeClickArea(StewPotScreen.class, 132, 34, 38, 16, new RecipeType[]{PotCategory.TYPE, BoilingCategory.TYPE, PotRestingCategory.TYPE, StewCookingCategory.TYPE});
        registry.addRecipeClickArea(KitchenStoveScreen.class, 61, 0, 54, 28, new RecipeType[]{RecipeTypes.FUELING});
        registry.addRecipeClickArea(PanScreen.class, 125, 30, 38, 16, new RecipeType[]{FryingCategory.TYPE});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }
}

