/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.stove;

import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.stove.ChimneyPotBlockEntity;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.blocks.stove.KitchenStove;
import com.teammoeg.caupona.blocks.stove.KitchenStoveContainer;
import com.teammoeg.caupona.client.CPParticles;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.ChimneyHelper;
import com.teammoeg.caupona.util.FuelType;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.Utils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;

public class KitchenStoveBlockEntity
extends CPBaseBlockEntity
implements Container,
MenuProvider,
IStove,
IInfinitable {
    private NonNullList<ItemStack> fuel = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public int process;
    public int processMax;
    private final int speed;
    private final int maxcd;
    private int cd;
    private float fuelMod = 1.0f;
    public BlockPos attachedChimney;
    private int chimneyTicks = 0;
    private int chimneyCheckTicks = 20;
    boolean isInfinite = false;
    public FuelType last = FuelType.OTHER;

    public KitchenStoveBlockEntity(BlockEntityType<KitchenStoveBlockEntity> tet, BlockPos p, BlockState s, int spd) {
        super(tet, p, s);
        this.speed = spd;
        this.maxcd = (Integer)CPConfig.SERVER.stoveCD.get() / this.speed;
        this.fuelMod = (float)((Double)CPConfig.SERVER.stoveFuel.get()).doubleValue();
        this.chimneyCheckTicks = (Integer)CPConfig.SERVER.chimneyCheck.get();
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.process = nbt.m_128451_("process");
        this.processMax = nbt.m_128451_("processMax");
        this.attachedChimney = nbt.m_128441_("chimneyPos") ? BlockPos.m_122022_((long)nbt.m_128454_("chimneyPos")) : null;
        this.last = FuelType.values()[nbt.m_128451_("fuel_type")];
        if (!isClient) {
            this.cd = nbt.m_128451_("cd");
            this.fuel.set(0, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("fuel")));
            this.chimneyTicks = nbt.m_128451_("chimneyTick");
            this.isInfinite = nbt.m_128471_("inf");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128405_("process", this.process);
        nbt.m_128405_("processMax", this.processMax);
        if (this.attachedChimney != null) {
            nbt.m_128356_("chimneyPos", this.attachedChimney.m_121878_());
        }
        nbt.m_128405_("fuel_type", this.last.ordinal());
        if (!isClient) {
            nbt.m_128405_("cd", this.cd);
            nbt.m_128365_("fuel", (Tag)((ItemStack)this.fuel.get(0)).serializeNBT());
            nbt.m_128405_("chimneyTick", this.chimneyTicks);
            nbt.m_128379_("inf", this.isInfinite);
        }
    }

    public void m_6211_() {
        this.fuel.clear();
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.fuel.get(0)).m_41619_();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.fuel, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.fuel, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.fuel.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.fuel.get(0);
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0 && itemstack.getCraftingRemainingItem().m_41619_();
    }

    public AbstractContainerMenu m_7208_(int a, Inventory b, Player c) {
        return new KitchenStoveContainer(a, b, this);
    }

    public Component m_5446_() {
        return Utils.translate("container.caupona.kitchen_stove.title");
    }

    private boolean consumeFuel() {
        int time = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.fuel.get(0)), (RecipeType)RecipeType.f_44108_);
        if (time <= 0) {
            this.processMax = 0;
            this.process = 0;
            return false;
        }
        this.last = FuelType.getType((ItemStack)this.fuel.get(0));
        ((ItemStack)this.fuel.get(0)).m_41774_(1);
        float ftime = (float)time * this.fuelMod / (float)this.speed;
        float frac = Mth.m_14187_((float)ftime);
        this.processMax = frac > 0.0f ? (this.process = (int)ftime + (this.f_58857_.f_46441_.m_188500_() < (double)frac ? 1 : 0)) : (this.process = (int)ftime);
        return true;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            BlockState bs = this.m_58900_();
            boolean syncNeeded = false;
            ++this.chimneyTicks;
            if (this.chimneyTicks >= this.chimneyCheckTicks) {
                this.chimneyTicks = 0;
                BlockPos newChimney = ChimneyHelper.getNearestChimney(this.m_58904_(), this.m_58899_(), 2);
                if (!Objects.equals(newChimney, this.attachedChimney)) {
                    this.attachedChimney = newChimney;
                    syncNeeded = true;
                }
            }
            boolean flag = false;
            if (this.process <= 0 && (((Boolean)bs.m_61143_((Property)KitchenStove.LIT)).booleanValue() || ((Boolean)bs.m_61143_((Property)KitchenStove.ASH)).booleanValue())) {
                bs = (BlockState)((BlockState)bs.m_61124_((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(false));
                flag = true;
            }
            int fs = (Integer)bs.m_61143_((Property)KitchenStove.FUELED);
            if (!((ItemStack)this.fuel.get(0)).m_41619_()) {
                FuelType type = FuelType.getType((ItemStack)this.fuel.get(0));
                if (type.getModelId() != fs) {
                    flag = true;
                    bs = (BlockState)bs.m_61124_((Property)KitchenStove.FUELED, (Comparable)Integer.valueOf(type.getModelId()));
                }
            } else if (fs != 0) {
                flag = true;
                bs = (BlockState)bs.m_61124_((Property)KitchenStove.FUELED, (Comparable)Integer.valueOf(0));
            }
            if (this.process > 0) {
                if (!((Boolean)bs.m_61143_((Property)KitchenStove.ASH)).booleanValue()) {
                    flag = true;
                    bs = (BlockState)bs.m_61124_((Property)KitchenStove.ASH, (Comparable)Boolean.valueOf(true));
                }
                if (((Boolean)bs.m_61143_((Property)KitchenStove.LIT)).booleanValue()) {
                    BlockEntity blockEntity;
                    --this.cd;
                    if (!this.isInfinite) {
                        --this.process;
                        syncNeeded = true;
                    }
                    if (this.attachedChimney != null && (blockEntity = this.m_58904_().m_7702_(this.attachedChimney)) instanceof ChimneyPotBlockEntity) {
                        ChimneyPotBlockEntity chimney = (ChimneyPotBlockEntity)blockEntity;
                        chimney.addAsh(this.speed);
                    }
                    if (this.cd <= 0) {
                        bs = (BlockState)bs.m_61124_((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(false));
                        flag = true;
                    }
                }
            }
            if (flag) {
                this.f_58857_.m_46597_(this.m_58899_(), bs);
            }
            if (syncNeeded) {
                this.syncData();
            }
        } else if (((Boolean)this.m_58900_().m_61143_((Property)KitchenStove.LIT)).booleanValue()) {
            double d0 = this.m_58899_().m_123341_();
            double d1 = this.m_58899_().m_123342_();
            double d2 = this.m_58899_().m_123343_();
            RandomSource rand = this.m_58904_().f_46441_;
            if (this.attachedChimney == null) {
                if (rand.m_188500_() < 0.25 * (double)this.speed) {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.5, d1 + 1.0, d2 + 0.5, rand.m_188500_() * 0.5 - 0.25, rand.m_188500_() * 0.125, rand.m_188500_() * 0.5 - 0.25);
                }
            } else if (rand.m_188500_() < 0.25 * (double)this.speed) {
                double motY = -0.3;
                double delY = 0.5;
                if (!this.m_58904_().m_8055_(this.attachedChimney).m_204336_(CPTags.Blocks.CHIMNEY_POT)) {
                    motY = rand.m_188500_() * 0.25;
                    delY = 0.0;
                }
                this.m_58904_().m_7106_((ParticleOptions)CPParticles.SOOT.get(), (double)this.attachedChimney.m_123341_() + 0.5, (double)this.attachedChimney.m_123342_() + delY, (double)this.attachedChimney.m_123343_() + 0.5, rand.m_188500_() * 0.5 - 0.25, motY, rand.m_188500_() * 0.5 - 0.25);
            }
        }
    }

    @Override
    public int requestHeat() {
        if (this.process <= 0) {
            if (!this.consumeFuel()) {
                return 0;
            }
            if (!this.isInfinite) {
                --this.process;
            }
        }
        BlockState bs = this.m_58900_();
        this.cd = this.maxcd;
        if (!((Boolean)bs.m_61143_((Property)KitchenStove.LIT)).booleanValue()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)bs.m_61124_((Property)KitchenStove.LIT, (Comparable)Boolean.valueOf(true)));
        }
        return this.speed;
    }

    @Override
    public boolean canEmitHeat() {
        return this.process > 0 || ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.fuel.get(0)), (RecipeType)RecipeType.f_44108_) > 0;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }
}

