/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.occultism.crafting.recipe.BoundBookOfBindingRecipe;
import com.klikli_dev.occultism.integration.modonomicon.OccultismModonomiconConstants;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class BookBindingCraftingRecipePage
extends BookRecipePage<Recipe<?>> {
    ItemStack unboundBook;

    public BookBindingCraftingRecipePage(BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text, String anchor, BookCondition condition, ItemStack unboundBook) {
        super(RecipeType.f_44107_, title1, recipeId1, title2, recipeId2, text, anchor, condition);
        this.unboundBook = unboundBook;
    }

    public static BookBindingCraftingRecipePage fromJson(JsonObject json) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromJson((JsonObject)json);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((JsonObject)json.getAsJsonObject("condition")) : new BookNoneCondition();
        ItemStack unboundBook = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("unbound_book"), (boolean)true);
        return new BookBindingCraftingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, (BookCondition)condition, unboundBook);
    }

    public static BookBindingCraftingRecipePage fromNetwork(FriendlyByteBuf buffer) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromNetwork((FriendlyByteBuf)buffer);
        String anchor = buffer.m_130277_();
        BookCondition condition = BookCondition.fromNetwork((FriendlyByteBuf)buffer);
        ItemStack unboundBook = buffer.m_130267_();
        return new BookBindingCraftingRecipePage(common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition, unboundBook);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.m_130055_(this.unboundBook);
    }

    public ResourceLocation getType() {
        return OccultismModonomiconConstants.Page.BOOK_BINDING_RECIPE;
    }

    protected ItemStack getRecipeOutput(Level level, Recipe<?> recipe) {
        if (recipe == null) {
            return ItemStack.f_41583_;
        }
        return BoundBookOfBindingRecipe.getBoundBookFromBook(this.unboundBook);
    }
}

