/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.util.FamiliarUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DevilFamiliarEntity
extends FamiliarEntity
implements GeoEntity {
    private final float heightOffset;
    AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DevilFamiliarEntity(EntityType<? extends DevilFamiliarEntity> type, Level level) {
        super(type, level);
        this.heightOffset = this.m_217043_().m_188501_() * 5.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_ && this.f_20911_) {
            Vec3 direction = Vec3.m_82503_((Vec2)this.m_20155_()).m_82490_(0.6);
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = this.m_20182_().m_82520_(direction.f_82479_ + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7, 1.5 + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7, direction.f_82481_ + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, direction.f_82479_ * 0.25, 0.0, direction.f_82481_ * 0.25);
            }
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + this.heightOffset + partialTicks) / 3.5f));
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19607_, 300, 0, false, false));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, "mainController", 0, this::animPredicate);
        controllerRegistrar.add(new AnimationController[]{mainController});
    }

    public int m_21304_() {
        return 11;
    }

    private <T extends GeoAnimatable> PlayState animPredicate(AnimationState<T> tAnimationState) {
        if (this.f_20911_) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        if (this.isSitting()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("sitting"));
            return PlayState.CONTINUE;
        }
        return tAnimationState.setAndContinue(tAnimationState.isMoving() ? RawAnimation.begin().thenPlay("walk") : RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public static class AttackGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 20;
        protected final FamiliarEntity entity;
        private final float range;
        private int cooldown = 20;

        public AttackGoal(FamiliarEntity entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        public boolean m_8036_() {
            return this.cooldown-- < 0 && this.entity.getFamiliarOwner() instanceof Player && !this.getNearbyEnemies().isEmpty();
        }

        private List<LivingEntity> getNearbyEnemies() {
            return FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, this.range);
        }

        public void m_8056_() {
            List<LivingEntity> enemies = this.getNearbyEnemies();
            if (!enemies.isEmpty() && this.entity instanceof DevilFamiliarEntity) {
                OccultismAdvancements.FAMILIAR.trigger(this.entity.getFamiliarOwner(), FamiliarTrigger.Type.DEVIL_FIRE);
            }
            this.attack(enemies);
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
            this.cooldown = 20;
        }

        protected void attack(List<LivingEntity> enemies) {
            for (Entity entity : enemies) {
                entity.m_6469_(this.entity.m_269291_().m_269075_((Player)this.entity.getFamiliarOwner()), 4.0f);
                entity.m_20254_(4);
            }
        }

        public void m_8041_() {
            this.cooldown = 20;
        }
    }
}

