/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.render.OccultismRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SelectedBlockRenderer {
    protected Set<SelectionInfo> selectedBlocks = new HashSet<SelectionInfo>();

    public void selectBlock(BlockPos pos, long expireTime) {
        this.selectBlock(pos, expireTime, new Color(1.0f, 1.0f, 1.0f, 0.8f));
    }

    public void selectBlock(BlockPos pos, long expireTime, Color color) {
        SelectionInfo info = new SelectionInfo(pos, expireTime, color);
        this.selectedBlocks.remove(info);
        this.selectedBlocks.add(info);
    }

    public void unselectBlock(BlockPos pos) {
        this.selectedBlocks.removeIf(info -> info.selectedBlock.equals((Object)pos));
    }

    @SubscribeEvent
    public void RenderLevelLastEvent(RenderLevelStageEvent event) {
        this.renderSelectedBlocks(event);
    }

    protected void renderSelectedBlocks(RenderLevelStageEvent event) {
        Boolean useAltRenderer = (Boolean)Occultism.CLIENT_CONFIG.visuals.useAlternativeDivinationRodRenderer.get();
        if (!useAltRenderer.booleanValue() && event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (useAltRenderer.booleanValue() && event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!this.selectedBlocks.isEmpty()) {
            long time = System.currentTimeMillis();
            PoseStack matrixStack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderType renderType = useAltRenderer != false ? OccultismRenderType.overlayLinesAlternative() : OccultismRenderType.overlayLines();
            VertexConsumer builder = buffer.m_6299_(renderType);
            matrixStack.m_85836_();
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 cameraPosition = camera.m_90583_();
            matrixStack.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
            Iterator<SelectionInfo> it = this.selectedBlocks.iterator();
            while (it.hasNext()) {
                SelectionInfo info = it.next();
                if (time > info.selectionExpireTime || info.selectedBlock == null) {
                    it.remove();
                    continue;
                }
                LevelRenderer.m_109608_((PoseStack)matrixStack, (VertexConsumer)builder, (double)info.selectedBlock.m_123341_(), (double)info.selectedBlock.m_123342_(), (double)info.selectedBlock.m_123343_(), (double)(info.selectedBlock.m_123341_() + 1), (double)(info.selectedBlock.m_123342_() + 1), (double)(info.selectedBlock.m_123343_() + 1), (float)((float)info.color.getRed() / 255.0f), (float)((float)info.color.getGreen() / 255.0f), (float)((float)info.color.getBlue() / 255.0f), (float)((float)info.color.getAlpha() / 255.0f));
            }
            matrixStack.m_85849_();
            RenderSystem.disableDepthTest();
            buffer.m_109911_();
        }
    }

    public class SelectionInfo {
        public BlockPos selectedBlock;
        public long selectionExpireTime;
        public Color color;

        public SelectionInfo(BlockPos selectedBlock, long selectionExpireTime, Color color) {
            this.selectedBlock = selectedBlock;
            this.selectionExpireTime = selectionExpireTime;
            this.color = color;
        }

        public int hashCode() {
            return this.selectedBlock.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            SelectionInfo other = (SelectionInfo)obj;
            if (other == null) {
                return false;
            }
            return other.selectedBlock.equals((Object)this.selectedBlock);
        }
    }
}

