/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import org.violetmoon.quark.content.world.module.MonsterBoxModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.BlockUtils;
import org.violetmoon.zeta.world.generator.Generator;

public class MonsterBoxGenerator
extends Generator {
    public MonsterBoxGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion world, ChunkGenerator generator, RandomSource rand, BlockPos chunkCorner) {
        if (generator instanceof FlatLevelSource) {
            return;
        }
        block0: for (double chance = MonsterBoxModule.chancePerChunk; chance > 0.0 && rand.m_188500_() <= chance; chance -= 1.0) {
            BlockPos.MutableBlockPos pos = chunkCorner.m_7918_(rand.m_188503_(16), rand.m_216339_(MonsterBoxModule.minY, MonsterBoxModule.maxY), rand.m_188503_(16)).m_122032_();
            for (int moves = 0; moves < MonsterBoxModule.searchRange && pos.m_123342_() > MonsterBoxModule.minY; ++moves) {
                BlockState state = world.m_8055_((BlockPos)pos);
                if (this.canPlaceHere(world, pos, state)) {
                    world.m_7731_((BlockPos)pos, MonsterBoxModule.monster_box.m_49966_(), 0);
                    continue block0;
                }
                pos = pos.m_122184_(0, -1, 0);
            }
        }
    }

    private boolean canPlaceHere(WorldGenRegion level, BlockPos.MutableBlockPos pos, BlockState state) {
        if (!state.m_247087_() || state.m_278721_()) {
            return false;
        }
        BlockPos.MutableBlockPos below = pos.m_122184_(0, -1, 0);
        BlockState belowState = level.m_8055_((BlockPos)below);
        boolean result = BlockUtils.isStoneBased((BlockState)belowState, (BlockGetter)level, (BlockPos)below) && belowState.m_60783_((BlockGetter)level, (BlockPos)below, Direction.UP);
        pos.m_122184_(0, 1, 0);
        return result;
    }
}

