/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.automation.block.FeedingTroughBlock;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.zeta.util.MiscUtil;

public class FeedingTroughBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private long internalRng = 0L;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super(FeedingTroughModule.blockEntityType, pos, state);
    }

    public void updateFoodHolder(Animal mob, Ingredient temptations, FakePlayer foodHolder) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (!temptations.test(stack) || !mob.m_6898_(stack)) continue;
            Inventory inventory = foodHolder.m_150109_();
            inventory.f_35974_.set(inventory.f_35977_, (Object)stack);
            Vec3 througPos = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82520_(0.5, -1.0, 0.5);
            Vec3 mobPosition = mob.m_20182_();
            Vec3 direction = mobPosition.m_82546_(througPos);
            Vec2 angles = MiscUtil.getMinecraftAnglesLossy((Vec3)direction);
            Vec3 newPos = Vec3.f_82478_;
            float maxDist = 5.0f;
            newPos = direction.m_82556_() > (double)(maxDist * maxDist) ? mobPosition.m_82549_(direction.m_82541_().m_82490_((double)(-maxDist))) : througPos.m_82549_(direction.m_82541_().m_82490_(-1.0));
            foodHolder.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, angles.f_82471_, angles.f_82470_);
            return;
        }
    }

    public FeedResult tryFeedingAnimal(Animal animal) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (!animal.m_6898_(stack)) continue;
            SoundEvent soundEvent = animal.m_7866_(stack);
            if (soundEvent != null) {
                animal.m_5496_(soundEvent, 0.5f + 0.5f * (float)this.f_58857_.f_46441_.m_188503_(2), (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.2f + 1.0f);
            }
            this.addItemParticles((Entity)animal, stack, 16);
            stack.m_41774_(1);
            this.m_6596_();
            if (this.getSpecialRand().nextDouble() < FeedingTroughModule.loveChance) {
                List animalsAround = this.f_58857_.m_45976_(Animal.class, new AABB(this.f_58858_).m_82400_(FeedingTroughModule.range));
                if (animalsAround.size() <= FeedingTroughModule.maxAnimals) {
                    animal.m_27595_(null);
                }
                return FeedResult.SECS;
            }
            return FeedResult.FED;
        }
        return FeedResult.NONE;
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.m_58900_();
        if (this.f_58857_ != null && state.m_60734_() instanceof FeedingTroughBlock) {
            boolean shouldBeFull;
            boolean full = (Boolean)state.m_61143_((Property)FeedingTroughBlock.FULL);
            boolean bl = shouldBeFull = !this.m_7983_();
            if (full != shouldBeFull) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(shouldBeFull)), 2);
            }
        }
    }

    private void addItemParticles(Entity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 direction = new Vec3(((double)entity.m_9236_().f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            direction = direction.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            direction = direction.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            double yVelocity = (double)(-entity.m_9236_().f_46441_.m_188501_()) * 0.6 - 0.3;
            Vec3 position = new Vec3(((double)entity.m_9236_().f_46441_.m_188501_() - 0.5) * 0.3, yVelocity, 0.6);
            Vec3 entityPos = entity.m_20182_();
            position = position.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(entityPos.f_82479_, entityPos.f_82480_ + (double)entity.m_20192_(), entityPos.f_82481_);
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), position.f_82479_, position.f_82480_, position.f_82481_, 1, direction.f_82479_, direction.f_82480_ + 0.05, direction.f_82481_, 0.0);
                continue;
            }
            if (this.f_58857_ == null) continue;
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), position.f_82479_, position.f_82480_, position.f_82481_, direction.f_82479_, direction.f_82480_ + 0.05, direction.f_82481_);
        }
    }

    private Random getSpecialRand() {
        Random specialRand = new Random(this.internalRng);
        this.internalRng = specialRand.nextLong();
        return specialRand;
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"quark.container.feeding_trough");
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.internalRng = nbt.m_128454_("rng");
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.stacks);
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("rng", this.internalRng);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.stacks);
        }
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory playerInventory) {
        return new DispenserMenu(id, playerInventory, (Container)this){

            public MenuType<?> m_6772_() {
                return FeedingTroughModule.menuType;
            }
        };
    }

    public static enum FeedResult {
        FED,
        SECS,
        NONE;

    }
}

