/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.container.ContainerDimChest;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimChestStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockEntityDimChest
extends BlockEntityFrequencyOwner {
    private static final float MIN_MOVABLE_POSITION = 0.0f;
    private static final float MAX_MOVABLE_POSITION = 0.5f;
    private static final float OPENING_SPEED = 0.05f;
    public float movablePartState = 0.0f;
    public int rotation;
    private int openCount;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();

    public BlockEntityDimChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.DIMCHEST_TILE.get(), pos, state);
    }

    @Override
    public void onServerTick(Level level, BlockPos pos, BlockState state) {
        if (level.m_46467_() % 20L == 0L || this.openCount != this.getStorage().getNumOpen()) {
            this.openCount = this.getStorage().getNumOpen();
            level.m_7696_(pos, state.m_60734_(), 1, this.openCount);
            level.m_46672_(this.f_58858_, state.m_60734_());
        }
        this.commonTick();
    }

    @Override
    public void onClientTick(Level level, BlockPos pos, BlockState state) {
        this.commonTick();
    }

    private void commonTick() {
        this.movablePartState = this.openCount > 0 ? (this.movablePartState < 0.5f ? (this.movablePartState += 0.05f) : 0.5f) : (this.movablePartState > 0.0f ? (this.movablePartState -= 0.05f) : 0.0f);
    }

    public int getComparatorInput() {
        return this.itemHandler.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Override
    public void setFrequency(Frequency frequency) {
        super.setFrequency(frequency);
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.getStorage()));
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.getStorage()));
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandler.invalidate();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            return true;
        }
        return false;
    }

    @Override
    public DimChestStorage getStorage() {
        return (DimChestStorage)DimStorageManager.instance(this.f_58857_.f_46443_).getStorage(this.getFrequency(), "item");
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)Math.floor((double)(entity.m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("rot", (byte)this.rotation);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rotation = tag.m_128445_("rot") & 3;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (!this.locked && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag root = new CompoundTag();
        root.m_128365_("Frequency", (Tag)this.getFrequency().serializeNBT());
        root.m_128379_("locked", this.locked);
        root.m_128344_("rot", (byte)this.rotation);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.setFrequency(new Frequency(tag.m_128469_("Frequency")));
        this.locked = tag.m_128471_("locked");
        this.rotation = tag.m_128445_("rot") & 3;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128344_("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.rotation = tag.m_128445_("rot") & 3;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerDimChest(id, inventory, this, false);
    }
}

