/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.shadowsoffire.hostilenetworks.client.WeirdRenderThings;
import dev.shadowsoffire.hostilenetworks.client.WrappedRTBuffer;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.util.ClientEntityCache;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="hostilenetworks")
public class DataModelItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final MultiBufferSource.BufferSource GHOST_ENTITY_BUF = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
    private static final ResourceLocation DATA_MODEL_BASE = new ResourceLocation("hostilenetworks", "item/data_model_base");

    public DataModelItemStackRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext type, PoseStack matrix, MultiBufferSource buf, int light, int overlay) {
        ItemRenderer irenderer = Minecraft.m_91087_().m_91291_();
        BakedModel base = irenderer.m_115103_().m_109393_().getModel(DATA_MODEL_BASE);
        matrix.m_85836_();
        if (type == ItemDisplayContext.FIXED) {
            matrix.m_252880_(1.0f, 1.0f, 0.0f);
            scale = 0.5f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_252880_(-1.5f, -0.5f, 0.5f);
            matrix.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrix.m_252880_(0.0f, 0.0f, -1.0f);
        } else if (type != ItemDisplayContext.GUI) {
            matrix.m_252880_(1.0f, 1.0f, 0.0f);
            scale = 0.5f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_252880_(-1.5f, -0.5f, 0.5f);
            matrix.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        } else {
            matrix.m_252880_(0.0f, -0.5f, -0.5f);
            matrix.m_252781_(Axis.f_252495_.m_252977_(75.0f));
            matrix.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            scale = 0.9f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85837_(0.775, 0.0, -0.0825);
        }
        irenderer.m_115189_(base, stack, light, overlay, matrix, ItemRenderer.m_115222_((MultiBufferSource)GHOST_ENTITY_BUF, (RenderType)ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        GHOST_ENTITY_BUF.m_109911_();
        matrix.m_85849_();
        DynamicHolder<DataModel> model = DataModelItem.getStoredModel(stack);
        if (model.isBound()) {
            LivingEntity ent = ClientEntityCache.computeIfAbsent(((DataModel)model.get()).type(), (Level)Minecraft.m_91087_().f_91073_, ((DataModel)model.get()).displayNbt());
            if (Minecraft.m_91087_().f_91074_ != null) {
                ent.f_19797_ = Minecraft.m_91087_().f_91074_.f_19797_;
            }
            if (ent != null) {
                this.renderEntityInInventory(matrix, type, ent, (DataModel)model.get());
            }
        }
    }

    public void renderEntityInInventory(PoseStack matrix, ItemDisplayContext type, LivingEntity pLivingEntity, DataModel model) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        if (type == ItemDisplayContext.FIXED) {
            matrix.m_85837_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.m_85841_(scale *= model.guiScale(), scale, scale);
            matrix.m_85837_(0.0, 1.45, 0.0);
            matrix.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            matrix.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        } else if (type == ItemDisplayContext.GUI) {
            matrix.m_85837_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.m_85841_(scale *= model.guiScale(), scale, scale);
            matrix.m_85837_(0.0, 0.45, 0.0);
        } else {
            scale = 0.25f;
            matrix.m_85841_(scale *= model.guiScale(), scale, scale);
            matrix.m_85837_(0.0, 0.12 + 0.05 * Math.sin(((float)pLivingEntity.f_19797_ + Minecraft.m_91087_().m_91297_()) / 12.0f), 0.0);
        }
        float rotation = -30.0f;
        if (type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            rotation = 30.0f;
        }
        if (type == ItemDisplayContext.FIXED) {
            rotation = 180.0f;
        }
        matrix.m_252781_(Axis.f_252436_.m_252977_(rotation));
        pLivingEntity.m_146922_(0.0f);
        pLivingEntity.f_20883_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20885_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20886_ = pLivingEntity.m_146908_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource rtBuffer = GHOST_ENTITY_BUF;
        WeirdRenderThings.translucent = true;
        RenderSystem.runAsFancy(() -> entityrenderermanager.m_114384_((Entity)pLivingEntity, (double)model.guiXOff(), (double)model.guiYOff(), (double)model.guiZOff(), 0.0f, Minecraft.m_91087_().m_91297_(), matrix, (MultiBufferSource)new WrappedRTBuffer((MultiBufferSource)rtBuffer), 0xF000F0));
        rtBuffer.m_109911_();
        WeirdRenderThings.translucent = false;
        entityrenderermanager.m_114468_(true);
        matrix.m_85849_();
    }
}

