/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.world.ChunkCache;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public final class WorldHelper {
    public static final int DIMENSION_ID_OVERWORLD = 0;
    public static final int DIMENSION_ID_NETHER = -1;
    public static final int DIMENSION_ID_THEEND = 1;

    public static Optional<Level> getClientWorld() {
        return ZeroCore.getProxy().getClientWorld();
    }

    public static Optional<ServerLevel> getServerWorld(ResourceKey<Level> worldKey) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return null != server ? Optional.ofNullable(server.m_129880_(worldKey)) : Optional.empty();
    }

    public static Stream<BlockPos> getNeighboringPositions(BlockPos origin) {
        return Stream.of(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST).map(arg_0 -> ((BlockPos)origin).m_121945_(arg_0));
    }

    public static BlockPos[] getNeighboringPositionsList(BlockPos origin, BlockPos[] storage) {
        for (int i = 0; i < CodeHelper.DIRECTIONS.length; ++i) {
            storage[i] = origin.m_121945_(CodeHelper.DIRECTIONS[i]);
        }
        return storage;
    }

    public static Optional<BlockState> getBlockState(Level world, BlockPos position) {
        return world.m_46749_(position) ? Optional.of(world.m_8055_(position)) : Optional.empty();
    }

    public static Stream<BlockState> getBlockStatesFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getBlockState);
    }

    public static Stream<Block> getBlocksFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getBlockStatesFrom(world, positions).map(BlockBehaviour.BlockStateBase::m_60734_);
    }

    public static void notifyBlockUpdate(Level world, BlockPos position) {
        WorldHelper.notifyBlockUpdate(world, position, null, null);
    }

    public static void notifyBlockUpdate(Level world, BlockPos position, @Nullable BlockState oldState, @Nullable BlockState newState) {
        if (null == oldState) {
            oldState = world.m_8055_(position);
        }
        if (null == newState) {
            newState = oldState;
        }
        world.m_7260_(position, oldState, newState, 3);
    }

    public static void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        ZeroCore.getProxy().markBlockRangeForRenderUpdate(min, max);
    }

    public static void notifyNeighborsOfStateChange(Level world, BlockPos pos, Block blockType) {
        world.m_46672_(pos, blockType);
    }

    @Nullable
    public static BlockEntity getLoadedTile(Level world, BlockPos position) {
        return world.m_46739_(position) ? WorldHelper.getLoadedTile((LevelChunk)world.m_6522_(position.m_123341_() >> 4, position.m_123343_() >> 4, ChunkStatus.f_62326_, false), position) : null;
    }

    @Nullable
    public static BlockEntity getLoadedTile(ChunkCache chunkCache, BlockPos position) {
        return chunkCache.getWorld().m_46739_(position) ? WorldHelper.getLoadedTile(chunkCache.get(position), position) : null;
    }

    @Nullable
    private static BlockEntity getLoadedTile(@Nullable LevelChunk chunk, BlockPos position) {
        return null != chunk ? chunk.m_5685_(position, LevelChunk.EntityCreationType.CHECK) : null;
    }

    public static Optional<BlockEntity> getTile(Level world, BlockPos position) {
        return world.m_6857_().m_61937_(position) ? Optional.ofNullable(WorldHelper.getLoadedTile(world, position)) : Optional.empty();
    }

    @Deprecated
    public static Optional<BlockEntity> getTile(BlockGetter world, BlockPos position) {
        if (world instanceof Level) {
            return Optional.ofNullable(WorldHelper.getLoadedTile((Level)world, position));
        }
        return Optional.ofNullable(world.m_7702_(position));
    }

    public static Optional<BlockEntity> getTile(Level world, BlockPos origin, Direction direction) {
        return WorldHelper.getTile(world, origin.m_121945_(direction));
    }

    public static Optional<BlockEntity> getTile(BlockEntity origin, Direction direction) {
        Level world = origin.m_58904_();
        return null != world ? WorldHelper.getTile(world, origin.m_58899_().m_121945_(direction)) : Optional.empty();
    }

    public static Stream<BlockEntity> getTilesFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getTile);
    }

    public static <Controller extends IMultiblockController<Controller>> Optional<IMultiblockPart<Controller>> getMultiblockPartFrom(Level world, BlockPos position) {
        return WorldHelper.getTile(world, position).filter(te -> te instanceof IMultiblockPart).map(te -> (IMultiblockPart)te);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends BlockEntity> Optional<T> getClientTile(BlockPos position) {
        return WorldHelper.getClientWorld().map(w -> WorldHelper.getLoadedTile(w, position));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends BlockEntity> Optional<T> getClientTile(BlockPos position, Direction direction) {
        return WorldHelper.getClientTile(position.m_121945_(direction));
    }

    public static int getChunkXFromBlock(int blockX) {
        return blockX >> 4;
    }

    public static int getChunkXFromBlock(BlockPos position) {
        return position.m_123341_() >> 4;
    }

    public static int getChunkZFromBlock(int blockZ) {
        return blockZ >> 4;
    }

    public static int getChunkZFromBlock(BlockPos position) {
        return position.m_123343_() >> 4;
    }

    public static long getChunkXZHashFromBlock(int blockX, int blockZ) {
        return ChunkPos.m_45589_((int)WorldHelper.getChunkXFromBlock(blockX), (int)WorldHelper.getChunkZFromBlock(blockZ));
    }

    public static long getChunkXZHashFromBlock(BlockPos position) {
        return ChunkPos.m_45589_((int)WorldHelper.getChunkXFromBlock(position), (int)WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean chunkExists(Level world, BlockPos position) {
        return world.m_7232_(WorldHelper.getChunkXFromBlock(position), WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean isEntityInRange(Entity entity, double x, double y, double z, double range) {
        return entity.m_20275_(x + 0.5, y + 0.5, z + 0.5) < range * range;
    }

    public static boolean isEntityInRange(Entity entity, BlockPos position, double range) {
        return entity.m_20275_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5) < range * range;
    }

    public static <T extends ParticleOptions> void spawnVanillaParticles(Level world, T particle, int minCount, int maxCount, int x, int y, int z, int offsetX, int offsetY, int offsetZ) {
        RandomSource rand = world.f_46441_;
        int howMany = Mth.m_216271_((RandomSource)rand, (int)minCount, (int)maxCount);
        double px1 = (double)(x - offsetX) + 0.5;
        double px2 = (double)(x + offsetX) + 0.5;
        double py1 = y;
        double py2 = y + offsetY;
        double pz1 = (double)(z - offsetZ) + 0.5;
        double pz2 = (double)(z + offsetZ) + 0.5;
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            double motionX = rand.m_188583_() * 0.02;
            double motionY = rand.m_188583_() * 0.02;
            double motionZ = rand.m_188583_() * 0.02;
            double pX = Mth.m_216263_((RandomSource)rand, (double)px1, (double)px2);
            double pY = Mth.m_216263_((RandomSource)rand, (double)py1, (double)py2);
            double pZ = Mth.m_216263_((RandomSource)rand, (double)pz1, (double)pz2);
            ws.m_8767_(particle, pX, pY, pZ, howMany, motionX, motionY, motionZ, rand.m_188583_() * 0.02);
        } else {
            for (int i = 0; i < howMany; ++i) {
                double motionX = rand.m_188583_() * 0.02;
                double motionY = rand.m_188583_() * 0.02;
                double motionZ = rand.m_188583_() * 0.02;
                double pX = Mth.m_216263_((RandomSource)rand, (double)px1, (double)px2);
                double pY = Mth.m_216263_((RandomSource)rand, (double)py1, (double)py2);
                double pZ = Mth.m_216263_((RandomSource)rand, (double)pz1, (double)pz2);
                world.m_7106_(particle, pX, pY, pZ, motionX, motionY, motionZ);
            }
        }
    }

    public static void spawnItemStack(ItemStack stack, Level world, double x, double y, double z, boolean withMomentum) {
        float z2;
        float y2;
        float x2;
        if (withMomentum) {
            x2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
            y2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
            z2 = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        } else {
            x2 = 0.5f;
            y2 = 0.0f;
            z2 = 0.5f;
        }
        ItemEntity entity = new ItemEntity(world, x + (double)x2, y + (double)y2, z + (double)z2, ItemHelper.stackFrom(stack));
        if (withMomentum) {
            entity.m_20334_(world.f_46441_.m_188583_() * (double)0.05f, world.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, world.f_46441_.m_188583_() * (double)0.05f);
        } else {
            entity.m_20334_(0.0, (double)-0.05f, 0.0);
        }
        world.m_7967_((Entity)entity);
    }

    public static boolean isFluidStateTagged(BlockGetter access, BlockPos position, TagKey<Fluid> tag) {
        return access.m_6425_(position).m_205070_(tag);
    }

    public static boolean isFluidStateTagged(BlockState blockState, TagKey<Fluid> tag) {
        return blockState.m_60819_().m_205070_(tag);
    }

    private static <T> Stream<T> getFromWorld(Level world, Stream<BlockPos> positions, BiFunction<Level, BlockPos, Optional<T>> getter) {
        return positions.map(position -> (Optional)getter.apply(world, (BlockPos)position)).filter(Optional::isPresent).map(Optional::get);
    }

    private WorldHelper() {
    }
}

