/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.stream.LongStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class NeighboringPositions {
    private final Direction[] _directions;
    private final BlockPos.MutableBlockPos[] _neighbors;
    private final long[] _neighborHashes;

    public NeighboringPositions() {
        this(0, 0, 0, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(Direction[] directions) {
        this(0, 0, 0, directions);
    }

    public NeighboringPositions(BlockPos position) {
        this(position.m_123341_(), position.m_123342_(), position.m_123343_(), CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(BlockPos position, Direction[] directions) {
        this(position.m_123341_(), position.m_123342_(), position.m_123343_(), directions);
    }

    public NeighboringPositions(int x, int y, int z) {
        this(x, y, z, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(int x, int y, int z, Direction[] directions) {
        int length = directions.length;
        this._directions = directions;
        this._neighbors = new BlockPos.MutableBlockPos[length];
        this._neighborHashes = new long[length];
        for (int i = 0; i < length; ++i) {
            BlockPos.MutableBlockPos position;
            this._neighbors[i] = position = new BlockPos.MutableBlockPos(x, y, z).m_122173_(this._directions[i]);
            this._neighborHashes[i] = position.m_121878_();
        }
    }

    public void setTo(BlockPos position) {
        this.setTo(position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    public void setTo(int x, int y, int z) {
        for (int i = 0; i < this._neighbors.length; ++i) {
            BlockPos.MutableBlockPos position = this._neighbors[i].m_122178_(x, y, z).m_122175_(this._directions[i], 1);
            this._neighborHashes[i] = position.m_121878_();
        }
    }

    public int size() {
        return this._neighbors.length;
    }

    public BlockPos get(int index) {
        return this._neighbors[index];
    }

    public long getHash(int index) {
        return this._neighborHashes[index];
    }

    public LongStream getHashStream() {
        return LongStream.of(this._neighborHashes);
    }
}

