/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ElementBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ItemOverrideBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ItemTransformBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ParentModel;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ParentModels;
import it.zerono.mods.zerocore.lib.functional.NonNullBiConsumer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ModelFileBuilder
implements Supplier<JsonElement> {
    private final ResourceLocation _id;
    private final boolean _targetIsItem;
    private final NonNullBiConsumer<ResourceLocation, Supplier<JsonElement>> _sink;
    private final List<Supplier<JsonElement>> _elements;
    private final Map<ItemDisplayContext, ItemTransformBuilder> _itemTransformations;
    private final List<Supplier<JsonElement>> _itemOverrides;
    private final Object2ObjectMap<String, String> _textures;
    @Nullable
    private ParentModel _parent;
    @Nullable
    private Item _itemToBeDelegated;
    private boolean _ambientOcclusion;
    private BlockModel.GuiLight _guiLight;

    public ModelFileBuilder(ResourceLocation id, NonNullBiConsumer<ResourceLocation, Supplier<JsonElement>> sink) {
        this._id = (ResourceLocation)Preconditions.checkNotNull((Object)id);
        this._sink = (NonNullBiConsumer)Preconditions.checkNotNull(sink);
        this._targetIsItem = this._id.m_135815_().startsWith("item");
        this._elements = new LinkedList<Supplier<JsonElement>>();
        this._textures = new Object2ObjectArrayMap(16);
        this._itemOverrides = new LinkedList<Supplier<JsonElement>>();
        this._itemTransformations = new Object2ObjectArrayMap(ItemDisplayContext.values().length);
        this._ambientOcclusion = true;
        this._guiLight = BlockModel.GuiLight.SIDE;
    }

    public ResourceLocation build() {
        this._sink.accept(this._id, this);
        if (null != this._itemToBeDelegated) {
            this._sink.accept(CodeHelper.getObjectId(this._itemToBeDelegated).m_246208_("item//"), (Supplier<JsonElement>)new DelegatedModel(this._id));
        }
        return this._id;
    }

    public <I extends ItemLike> ModelFileBuilder delegateFor(Supplier<I> item) {
        Preconditions.checkNotNull(item, (Object)"Item must not be null");
        this.ensureBlockOnly();
        this._itemToBeDelegated = ((ItemLike)item.get()).m_5456_();
        return this;
    }

    public ModelFileBuilder parent(ParentModel parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        Preconditions.checkState((null == this._parent ? 1 : 0) != 0, (String)"A parent model is already defined: %s", (Object)this._parent);
        this._parent = parent;
        parent.textures().forEach(variable -> this._textures.put(variable, null));
        return this;
    }

    public ModelFileBuilder parent(ResourceLocation model) {
        return this.parent(ParentModel.of(model));
    }

    public ModelFileBuilder texture(String variable, String texture) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)variable) ? 1 : 0) != 0, (Object)"Variable must be not null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)texture) ? 1 : 0) != 0, (Object)"Texture must be not null or empty");
        Preconditions.checkState((null == this._textures.get((Object)variable) ? 1 : 0) != 0, (String)"A texture is already defined for %s", (Object)variable);
        this._textures.put((Object)variable, (Object)texture);
        return this;
    }

    public ModelFileBuilder texture(String variable, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        return this.texture(variable, texture.toString());
    }

    public ModelFileBuilder texture(TextureSlot variable, String texture) {
        Preconditions.checkNotNull((Object)variable, (Object)"Variable must not be null");
        return this.texture(variable.m_125897_(), texture);
    }

    public ModelFileBuilder texture(TextureSlot variable, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)variable, (Object)"Variable must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        return this.texture(variable.m_125897_(), texture.toString());
    }

    public ModelFileBuilder element(NonNullConsumer<ElementBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        this._elements.add((Supplier)Util.m_137469_((Object)new ElementBuilder(), arg_0 -> builder.accept(arg_0)));
        return this;
    }

    public ModelFileBuilder transformation(ItemDisplayContext type, NonNullConsumer<ItemTransformBuilder> builder) {
        Preconditions.checkNotNull((Object)type, (Object)"Transformation type must not be null");
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        Preconditions.checkState((!this._itemTransformations.containsKey(type) ? 1 : 0) != 0, (String)"Item transformation %s is already defined", (Object)type);
        this._itemTransformations.put(type, (ItemTransformBuilder)Util.m_137469_((Object)new ItemTransformBuilder(), arg_0 -> builder.accept(arg_0)));
        return this;
    }

    public ModelFileBuilder override(NonNullConsumer<ItemOverrideBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        this.ensureItemOnly();
        this._itemOverrides.add((Supplier)Util.m_137469_((Object)new ItemOverrideBuilder(), arg_0 -> builder.accept(arg_0)));
        return this;
    }

    public ModelFileBuilder ambientOcclusion(boolean useAmbientOcclusion) {
        this.ensureBlockOnly();
        this._ambientOcclusion = useAmbientOcclusion;
        return this;
    }

    public ModelFileBuilder guiLight(BlockModel.GuiLight light) {
        Preconditions.checkNotNull((Object)light, (Object)"Light must not be null");
        this.ensureItemOnly();
        this._guiLight = light;
        return this;
    }

    public ResourceLocation withSingleTextureParent(ParentModel parent, String textureVariable, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)textureVariable) ? 1 : 0) != 0, (Object)"Texture variable must not be null or empty");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        return this.parent(parent).texture(textureVariable, texture).build();
    }

    public ResourceLocation withSingleTextureParent(ParentModel parent, TextureSlot textureVariable, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)textureVariable, (Object)"Texture variable must not be null");
        return this.withSingleTextureParent(parent, textureVariable.m_125897_(), texture);
    }

    public ResourceLocation withDoubleTextureParent(ParentModel parent, String textureVariable1, ResourceLocation texture1, String textureVariable2, ResourceLocation texture2) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)textureVariable1) ? 1 : 0) != 0, (Object)"Texture variable 1 must not be null or empty");
        Preconditions.checkNotNull((Object)texture1, (Object)"Texture 1 must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)textureVariable2) ? 1 : 0) != 0, (Object)"Texture variable 2 must not be null or empty");
        Preconditions.checkNotNull((Object)texture2, (Object)"Texture 2 must not be null");
        return this.parent(parent).texture(textureVariable1, texture1).texture(textureVariable2, texture2).build();
    }

    public ResourceLocation withDoubleTextureParent(ParentModel parent, TextureSlot textureVariable1, ResourceLocation texture1, TextureSlot textureVariable2, ResourceLocation texture2) {
        Preconditions.checkNotNull((Object)textureVariable1, (Object)"Texture variable 1 must not be null");
        Preconditions.checkNotNull((Object)textureVariable2, (Object)"Texture variable 2 must not be null");
        return this.withDoubleTextureParent(parent, textureVariable1.m_125897_(), texture1, textureVariable2.m_125897_(), texture2);
    }

    public ResourceLocation withBottomTopSideTextures(ParentModel parent, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        Preconditions.checkNotNull((Object)bottom, (Object)"Bottom must not be null");
        Preconditions.checkNotNull((Object)bottom, (Object)"Top must not be null");
        Preconditions.checkNotNull((Object)bottom, (Object)"Side must not be null");
        return this.parent(parent).texture(TextureSlot.f_125871_, bottom).texture(TextureSlot.f_125872_, top).texture(TextureSlot.f_125875_, side).build();
    }

    public ResourceLocation flatItem(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.ITEM_GENERATED, TextureSlot.f_125863_, texture);
    }

    public ResourceLocation flatItemHandheld(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.ITEM_HANDHELD, TextureSlot.f_125863_, texture);
    }

    public ResourceLocation cube(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.CUBE_ALL, TextureSlot.f_125867_, texture);
    }

    public ResourceLocation cube(ResourceLocation particle, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation up, ResourceLocation down) {
        return this.parent(ParentModels.CUBE).texture(TextureSlot.f_125869_, particle).texture(TextureSlot.f_125876_, north).texture(TextureSlot.f_125877_, south).texture(TextureSlot.f_125878_, east).texture(TextureSlot.f_125879_, west).texture(TextureSlot.f_125880_, up).texture(TextureSlot.f_125881_, down).build();
    }

    public ResourceLocation cubeMirrored(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.CUBE_MIRRORED_ALL, TextureSlot.f_125867_, texture);
    }

    public ResourceLocation cubeMirrored(ResourceLocation particle, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation up, ResourceLocation down) {
        return this.parent(ParentModels.CUBE_MIRRORED).texture(TextureSlot.f_125869_, particle).texture(TextureSlot.f_125876_, north).texture(TextureSlot.f_125877_, south).texture(TextureSlot.f_125878_, east).texture(TextureSlot.f_125879_, west).texture(TextureSlot.f_125880_, up).texture(TextureSlot.f_125881_, down).build();
    }

    public ResourceLocation cubeHorizontalColumn(ResourceLocation side, ResourceLocation ends) {
        return this.parent(ParentModels.CUBE_COLUMN_HORIZONTAL).texture(TextureSlot.f_125875_, side).texture(TextureSlot.f_125870_, ends).build();
    }

    public ResourceLocation cubeVerticalColumn(ResourceLocation side, ResourceLocation ends) {
        return this.parent(ParentModels.CUBE_COLUMN_VERTICAL).texture(TextureSlot.f_125875_, side).texture(TextureSlot.f_125870_, ends).build();
    }

    public ResourceLocation cubeVerticalColumn(ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.withBottomTopSideTextures(ParentModels.CUBE_BOTTOM_TOP, bottom, top, side);
    }

    public ResourceLocation cubeOrientable(ResourceLocation front, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.parent(ParentModels.CUBE_ORIENTABLE).texture(TextureSlot.f_125873_, front).texture(TextureSlot.f_125875_, side).texture(TextureSlot.f_125872_, top).texture(TextureSlot.f_125871_, bottom).build();
    }

    public ResourceLocation cubeOrientableCapped(ResourceLocation front, ResourceLocation side, ResourceLocation ends) {
        return this.parent(ParentModels.CUBE_ORIENTABLE_CAPPED).texture(TextureSlot.f_125873_, front).texture(TextureSlot.f_125875_, side).texture(TextureSlot.f_125872_, ends).build();
    }

    public ResourceLocation wood(ResourceLocation wood) {
        return this.cubeVerticalColumn(wood, wood);
    }

    public ResourceLocation woodHorizontalLog(ResourceLocation side, ResourceLocation ends) {
        return this.cubeHorizontalColumn(side, ends);
    }

    public ResourceLocation woodVerticalLog(ResourceLocation side, ResourceLocation ends) {
        return this.cubeVerticalColumn(side, ends);
    }

    public ResourceLocation woodPLanks(ResourceLocation texture) {
        return this.cube(texture);
    }

    public ResourceLocation button(boolean isPressed, ResourceLocation texture) {
        return this.withSingleTextureParent(isPressed ? ParentModels.BUTTON_PRESSED : ParentModels.BUTTON, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation buttonItem(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.BUTTON_ITEM, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation doorClosedBottomLeft(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_CLOSED_BOTTOM_LEFT, TextureSlot.f_125871_, texture);
    }

    public ResourceLocation doorClosedBottomRight(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_CLOSED_BOTTOM_RIGHT, TextureSlot.f_125871_, texture);
    }

    public ResourceLocation doorClosedTopLeft(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_CLOSED_TOP_LEFT, TextureSlot.f_125872_, texture);
    }

    public ResourceLocation doorClosedTopRight(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_CLOSED_TOP_RIGHT, TextureSlot.f_125872_, texture);
    }

    public ResourceLocation doorOpenBottomLeft(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_OPEN_BOTTOM_LEFT, TextureSlot.f_125871_, texture);
    }

    public ResourceLocation doorOpenBottomRight(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_OPEN_BOTTOM_RIGHT, TextureSlot.f_125871_, texture);
    }

    public ResourceLocation doorOpenTopLeft(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_OPEN_TOP_LEFT, TextureSlot.f_125872_, texture);
    }

    public ResourceLocation doorOpenTopRight(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.DOOR_OPEN_TOP_RIGHT, TextureSlot.f_125872_, texture);
    }

    public ResourceLocation doorItem(ResourceLocation texture) {
        return this.flatItem(texture);
    }

    public ResourceLocation fencePost(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_POST, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceSide(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_SIDE, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceItem(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_ITEM, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceGateClosed(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_GATE_CLOSED, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceGateOpen(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_GATE_OPEN, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceGateWallClosed(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_GATE_WALL_CLOSED, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation fenceGateWallOpen(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.FENCE_GATE_WALL_OPEN, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation wallPost(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.WALL_POST, TextureSlot.f_125884_, texture);
    }

    public ResourceLocation wallLowSide(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.WALL_LOW_SIDE, TextureSlot.f_125884_, texture);
    }

    public ResourceLocation wallTallSide(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.WALL_TALL_SIDE, TextureSlot.f_125884_, texture);
    }

    public ResourceLocation wallItem(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.WALL_ITEM, TextureSlot.f_125884_, texture);
    }

    public ResourceLocation pressurePlate(boolean isPressed, ResourceLocation texture) {
        return this.withSingleTextureParent(isPressed ? ParentModels.PRESSURE_PLATE_PRESSED : ParentModels.PRESSURE_PLATE, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation slab(boolean isTop, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.withBottomTopSideTextures(isTop ? ParentModels.SLAB_TOP : ParentModels.SLAB, bottom, top, side);
    }

    public ResourceLocation leaves(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.LEAVES, TextureSlot.f_125867_, texture);
    }

    public ResourceLocation stairsStraight(ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.withBottomTopSideTextures(ParentModels.STAIRS_STRAIGHT, bottom, top, side);
    }

    public ResourceLocation stairsInner(ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.withBottomTopSideTextures(ParentModels.STAIRS_INNER, bottom, top, side);
    }

    public ResourceLocation stairsOuter(ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.withBottomTopSideTextures(ParentModels.STAIRS_OUTER, bottom, top, side);
    }

    public ResourceLocation trapdoorTop(boolean orientable, ResourceLocation texture) {
        return this.withSingleTextureParent(orientable ? ParentModels.TRAPDOOR_TOP_ORIENTABLE : ParentModels.TRAPDOOR_TOP, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation trapdoorBottom(boolean orientable, ResourceLocation texture) {
        return this.withSingleTextureParent(orientable ? ParentModels.TRAPDOOR_BOTTOM_ORIENTABLE : ParentModels.TRAPDOOR_BOTTOM, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation trapdoorOpen(boolean orientable, ResourceLocation texture) {
        return this.withSingleTextureParent(orientable ? ParentModels.TRAPDOOR_OPEN_ORIENTABLE : ParentModels.TRAPDOOR_OPEN, TextureSlot.f_125868_, texture);
    }

    public ResourceLocation railFlat(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.RAIL_FLAT, TextureSlot.f_125885_, texture);
    }

    public ResourceLocation railCorner(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.RAIL_CORNER, TextureSlot.f_125885_, texture);
    }

    public ResourceLocation railRaisedNE(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.RAIL_RAISED_NE, TextureSlot.f_125885_, texture);
    }

    public ResourceLocation railRaisedSW(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.RAIL_RAISED_SW, TextureSlot.f_125885_, texture);
    }

    public ResourceLocation railItem(ResourceLocation texture) {
        return this.flatItem(texture);
    }

    public ResourceLocation glassPaneNoSide(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.STAINED_GLASS_PANE_NOSIDE, TextureSlot.f_125888_, texture);
    }

    public ResourceLocation glassPaneNoSideAlt(ResourceLocation texture) {
        return this.withSingleTextureParent(ParentModels.STAINED_GLASS_PANE_NOSIDE_ALT, TextureSlot.f_125888_, texture);
    }

    public ResourceLocation glassPanePost(ResourceLocation pane, ResourceLocation edge) {
        return this.withDoubleTextureParent(ParentModels.STAINED_GLASS_PANE_POST, TextureSlot.f_125888_, pane, TextureSlot.f_125889_, edge);
    }

    public ResourceLocation glassPaneSide(ResourceLocation pane, ResourceLocation edge) {
        return this.withDoubleTextureParent(ParentModels.STAINED_GLASS_PANE_SIDE, TextureSlot.f_125888_, pane, TextureSlot.f_125889_, edge);
    }

    public ResourceLocation glassPaneSideAlt(ResourceLocation pane, ResourceLocation edge) {
        return this.withDoubleTextureParent(ParentModels.STAINED_GLASS_PANE_SIDE_ALT, TextureSlot.f_125888_, pane, TextureSlot.f_125889_, edge);
    }

    public ResourceLocation glassPaneItem(ResourceLocation texture) {
        return this.flatItem(texture);
    }

    @Override
    @ApiStatus.Internal
    public JsonElement get() {
        JsonObject json;
        JsonObject jsonObject = json = null != this._parent ? this._parent.get().getAsJsonObject() : new JsonObject();
        if (!this._ambientOcclusion) {
            json.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (!this._itemTransformations.isEmpty()) {
            JsonObject display = new JsonObject();
            this._itemTransformations.entrySet().stream().filter(e -> e.getKey() != ItemDisplayContext.NONE).forEach(e -> display.add(((ItemDisplayContext)e.getKey()).m_7912_(), ((ItemTransformBuilder)e.getValue()).get()));
            if (display.size() > 0) {
                json.add("display", (JsonElement)display);
            }
        }
        if (!this._textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            for (Map.Entry entry : this._textures.entrySet()) {
                Preconditions.checkState((null != entry.getValue() ? 1 : 0) != 0, (String)"Missing texture for variable %s", entry.getKey());
                textures.addProperty((String)entry.getKey(), JSONHelper.serializeTextureName((String)entry.getValue()));
            }
            json.add("textures", (JsonElement)textures);
        }
        if (BlockModel.GuiLight.SIDE != this._guiLight) {
            json.addProperty("gui_light", this._guiLight.getSerializedName());
        }
        if (!this._elements.isEmpty()) {
            json.add("elements", (JsonElement)JSONHelper.toArray(this._elements));
        }
        if (!this._itemOverrides.isEmpty()) {
            json.add("overrides", (JsonElement)JSONHelper.toArray(this._itemOverrides));
        }
        return json;
    }

    protected void ensureBlockOnly() {
        if (this._targetIsItem) {
            throw new UnsupportedOperationException("Operation permitted only on block models");
        }
    }

    protected void ensureItemOnly() {
        if (!this._targetIsItem) {
            throw new UnsupportedOperationException("Operation permitted only on item models");
        }
    }
}

