/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelFileBuilder;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.NonNullFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelBuilder
implements NonNullFunction<CachedOutput, CompletableFuture<?>> {
    public static final String BLOCK_PREFIX = "block/";
    public static final String ITEM_PREFIX = "item/";
    private final PackOutput.PathProvider _pathProvider;
    private final Map<ResourceLocation, Supplier<JsonElement>> _models;

    public ModelBuilder(PackOutput output) {
        Preconditions.checkNotNull((Object)output);
        this._pathProvider = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        this._models = new Object2ObjectArrayMap(128);
    }

    public ModelFileBuilder model(ResourceLocation id) {
        ModelBuilder.checkId(id);
        return this.modelInternal(id, null, null);
    }

    public ModelFileBuilder model(ResourceLocation baseId, String suffix) {
        ModelBuilder.checkId(baseId);
        return this.modelInternal(baseId, null, suffix);
    }

    public <B extends Block> ModelFileBuilder block(B block) {
        return this.blockInternal(block, null);
    }

    public <B extends Block> ModelFileBuilder block(B block, String suffix) {
        ModelBuilder.checkSuffix(suffix);
        return this.blockInternal(block, suffix);
    }

    public <B extends Block> ModelFileBuilder block(Supplier<B> block) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.blockInternal((Block)block.get(), null);
    }

    public <B extends Block> ModelFileBuilder block(Supplier<B> block, String suffix) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        ModelBuilder.checkSuffix(suffix);
        return this.blockInternal((Block)block.get(), suffix);
    }

    public <I extends ItemLike> ModelFileBuilder item(I item) {
        return this.itemInternal(item, null);
    }

    public <I extends ItemLike> ModelFileBuilder item(I item, String suffix) {
        ModelBuilder.checkSuffix(suffix);
        return this.itemInternal(item, null);
    }

    public <I extends ItemLike> ModelFileBuilder item(Supplier<I> item) {
        Preconditions.checkNotNull(item, (Object)"Item must not be null");
        return this.itemInternal((ItemLike)item.get(), null);
    }

    public <I extends ItemLike> ModelFileBuilder item(Supplier<I> item, String suffix) {
        Preconditions.checkNotNull(item, (Object)"Item must not be null");
        ModelBuilder.checkSuffix(suffix);
        return this.itemInternal((ItemLike)item.get(), suffix);
    }

    public <B extends Block> ResourceLocation defaultBlockTexture(Supplier<B> block) {
        return CodeHelper.getObjectId((Block)block.get()).m_246208_(BLOCK_PREFIX);
    }

    public <I extends ItemLike> ResourceLocation defaultItemTexture(Supplier<I> item) {
        return CodeHelper.getObjectId(((ItemLike)item.get()).m_5456_()).m_246208_(ITEM_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<?> apply(@NotNull CachedOutput output) {
        return CompletableFuture.allOf((CompletableFuture[])this._models.entrySet().stream().map(e -> DataProvider.m_253162_((CachedOutput)output, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)this._pathProvider.m_245731_((ResourceLocation)e.getKey()))).toArray(CompletableFuture[]::new));
    }

    private void sink(ResourceLocation id, Supplier<JsonElement> jsonSupplier) {
        ModelBuilder.checkId(id);
        Preconditions.checkNotNull(jsonSupplier);
        Preconditions.checkState((!this._models.containsKey(id) ? 1 : 0) != 0, (String)"A model is already defined for ID %s", (Object)id);
        this._models.put(id, jsonSupplier);
    }

    private ModelFileBuilder modelInternal(ResourceLocation baseId, @Nullable String prefix, @Nullable String suffix) {
        if (null != prefix) {
            baseId = baseId.m_246208_(prefix);
        }
        if (null != suffix) {
            baseId = baseId.m_247266_(basePath -> basePath + suffix);
        }
        return new ModelFileBuilder(baseId, this::sink);
    }

    private <B extends Block> ModelFileBuilder blockInternal(B block, @Nullable String suffix) {
        Preconditions.checkNotNull(block, (Object)"Block must not be null");
        return this.modelInternal(CodeHelper.getObjectId(block), BLOCK_PREFIX, suffix);
    }

    private <I extends ItemLike> ModelFileBuilder itemInternal(I item, @Nullable String suffix) {
        Preconditions.checkNotNull(item, (Object)"Item must not be null");
        return this.modelInternal(CodeHelper.getObjectId(item.m_5456_()), ITEM_PREFIX, suffix);
    }

    private static void checkId(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id, (Object)"The ID must not be null");
    }

    private static void checkSuffix(String suffix) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)suffix) ? 1 : 0) != 0, (Object)"The suffix must not be null or empty");
    }
}

