/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import it.zerono.mods.zerocore.internal.Log;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DependencyServiceLoader<T>
implements java.util.function.Supplier<T>,
Consumer<Consumer<T>> {
    private final java.util.function.Supplier<T> _service;

    public DependencyServiceLoader(Class<T> service) {
        this(DependencyServiceLoader.loadOrFail(service));
    }

    @ApiStatus.Internal
    protected DependencyServiceLoader(Supplier<@NotNull T> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"Supplier must not be null");
        this._service = Suppliers.memoize(supplier);
    }

    @Override
    public void accept(Consumer<@NotNull T> consumer) {
        consumer.accept(this.get());
    }

    @Override
    public T get() {
        return this._service.get();
    }

    protected static <P> Supplier<@NotNull P> loadOrFallback(Class<P> service, java.util.function.Supplier<@NotNull P> fallbackFactory) {
        Preconditions.checkNotNull(service, (Object)"Service must not be null");
        Preconditions.checkNotNull(fallbackFactory, (Object)"Fallback factory must not be null");
        return () -> {
            try {
                return ServiceLoader.load(service).findFirst().orElseGet(fallbackFactory);
            }
            catch (ServiceConfigurationError ex) {
                Log.LOGGER.warn(Log.SERVICE_LOADER, "Invalid service definition for {}. Using fallback implementation.", (Object)service.getName());
                return fallbackFactory.get();
            }
        };
    }

    protected static <P> Supplier<@NotNull P> loadOrFail(Class<P> service) {
        return DependencyServiceLoader.loadOrFallback(service, () -> {
            throw new IllegalStateException(String.format("Unable to load required service %s", service.getName()));
        });
    }
}

