/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.compat.patchouli.Patchouli;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HelpButton
extends Button {
    protected final Runnable _onClick;

    public static HelpButton patchouli(ModContainerScreen<? extends ModContainer> gui, String name, ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        HelpButton button = new HelpButton(gui, name, "?", () -> Patchouli.openBookEntry(bookId, entryId, pageNum));
        if (Mods.PATCHOULI.isPresent()) {
            button.Clicked.subscribe(button::onClick);
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"zerocore:gui.manual.open")));
        } else {
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"zerocore:gui.patchouli.missing")));
            button.setEnabled(false);
        }
        return button;
    }

    public static HelpButton jeiRecipes(ModContainerScreen<? extends ModContainer> gui, String name, String tooltipTranslationKey, Runnable onClick) {
        HelpButton button = new HelpButton(gui, name, "#", onClick);
        if (Mods.JEI.isPresent()) {
            button.Clicked.subscribe(button::onClick);
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)tooltipTranslationKey)));
        } else {
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"zerocore:gui.jei.missing")));
            button.setEnabled(false);
        }
        return button;
    }

    protected HelpButton(ModContainerScreen<? extends ModContainer> gui, String name, String label, Runnable onClick) {
        super(gui, name, label);
        Preconditions.checkNotNull((Object)onClick, (Object)"On Click must not be null");
        this._onClick = onClick;
        this.setDesiredDimension(14, 14);
    }

    private void onClick(Button button, int mouseButton) {
        button.enqueueTask(() -> {
            this._onClick.run();
            this.setMouseOver(false, 0, 0);
        });
    }
}

