/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompoundControl;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.validator.IControlValidator;
import it.zerono.mods.zerocore.lib.data.Flags;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractControlContainer
extends AbstractCompoundControl
implements IControlContainer {
    private static final ILayoutEngine DEFAULT_LAYOUT_ENGINE = new FixedLayoutEngine().setZeroMargins();
    private final Flags<ContainerFlags> _flags = new Flags<ContainerFlags>(ContainerFlags.class);
    private ILayoutEngine _layoutEngine = DEFAULT_LAYOUT_ENGINE;
    private IControlValidator _validator = (c, e) -> {};

    @Override
    public void addControl(@NotNull IControl control) {
        this.addChildControl(control);
        this.requestLayoutRun();
    }

    @Override
    public void addControl(IControl ... controls) {
        this.addChildControl(controls);
        this.requestLayoutRun();
    }

    @Override
    public void removeControl(@NotNull IControl control) {
        this.removeChildControl(control);
        this.requestLayoutRun();
    }

    @Override
    public void removeControls() {
        this.removeChildrenControls();
        this.requestLayoutRun();
    }

    @Override
    public int getControlsCount() {
        return this.getChildrenControlsCount();
    }

    @Override
    public ILayoutEngine getLayoutEngine() {
        return this._layoutEngine;
    }

    @Override
    public void setLayoutEngine(ILayoutEngine engine) {
        this._layoutEngine = engine;
        this.requestLayoutRun();
    }

    @Override
    public void setValidator(IControlValidator validator) {
        this._validator = validator;
    }

    @Override
    public void validate(Consumer<Component> errorReport) {
        this._validator.validate(this, errorReport);
        this.forEach(control -> {
            if (control instanceof IControlContainer) {
                ((IControlContainer)control).validate(errorReport);
            }
        });
    }

    @Override
    public Optional<IControl> findControl(int x, int y) {
        if (this.isLayoutRunRequested()) {
            this.runLayoutEngine();
        }
        return super.findControl(x, y);
    }

    @Override
    public void setDesiredDimension(DesiredDimension dimension, int value) {
        super.setDesiredDimension(dimension, value);
        this.setBoundsFromDesiredDimension();
    }

    @Override
    public void setDesiredDimension(int width, int height) {
        super.setDesiredDimension(width, height);
        this.setBoundsFromDesiredDimension();
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.requestLayoutRun();
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        if (this.isLayoutRunRequested()) {
            this.runLayoutEngine();
        }
        super.onPaintBackground(gfx, partialTicks, mouseX, mouseY);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" contFlags:").append(this._flags);
    }

    protected AbstractControlContainer(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
    }

    protected boolean isLayoutRunRequested() {
        return this._flags.contains(ContainerFlags.RunLayoutEngine);
    }

    protected void requestLayoutRun() {
        this._flags.add(ContainerFlags.RunLayoutEngine);
    }

    protected void runLayoutEngine() {
        this._layoutEngine.layout(this);
        this._flags.remove(ContainerFlags.RunLayoutEngine);
    }

    private void setBoundsFromDesiredDimension() {
        Rectangle bounds = new Rectangle(this.getBounds().Origin, this.getDesiredDimension(DesiredDimension.Width), this.getDesiredDimension(DesiredDimension.Height));
        this.setBounds(bounds);
    }

    private static enum ContainerFlags {
        RunLayoutEngine;

    }
}

