/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCompoundControl
extends AbstractControl
implements Iterable<IControl> {
    private final List<IControl> _children = Lists.newArrayList();

    public Stream<IControl> stream() {
        return this._children.stream();
    }

    @Override
    public Optional<IControl> findControl(int x, int y) {
        int childX = this.parentToChildX(x);
        int childY = this.parentToChildY(y);
        for (IControl child : this) {
            if (!child.hitTest(childX, childY) || !child.getVisible()) continue;
            return child.findControl(childX, childY);
        }
        return Optional.of(this);
    }

    @Override
    public Optional<IControl> findControl(String name) {
        Optional<IControl> result = super.findControl(name);
        if (result.isPresent()) {
            return result;
        }
        for (IControl child : this) {
            result = child.findControl(name);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public boolean containsControl(IControl control) {
        if (super.containsControl(control)) {
            return true;
        }
        for (IControl child : this) {
            if (!child.containsControl(control)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.updateChildrenControlOrigin();
    }

    @Override
    public void translate(int xOffset, int yOffset) {
        super.translate(xOffset, yOffset);
        this.updateChildrenControlOrigin();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.forEach(c -> c.setEnabled(enabled));
    }

    @Override
    public boolean onMouseMoved(IWindow wnd, int mouseX, int mouseY) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible() || !child.hitTest(childX, childY)) continue;
            return child.onMouseMoved(wnd, childX, childY);
        }
        return false;
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible() || !child.hitTest(childX, childY)) continue;
            return child.getEnabled() && child.onMouseClicked(wnd, childX, childY, clickedButton);
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible() || !child.hitTest(childX, childY)) continue;
            return child.getEnabled() && child.onMouseReleased(wnd, childX, childY, releasedButton);
        }
        return false;
    }

    @Override
    public boolean onMouseWheel(IWindow wnd, int mouseX, int mouseY, double movement) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible() || !child.hitTest(childX, childY)) continue;
            return child.getEnabled() && child.onMouseWheel(wnd, childX, childY, movement);
        }
        return false;
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.onPaintBackground(gfx, partialTicks, mouseX, mouseY);
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible()) continue;
            child.onPaintBackground(gfx, partialTicks, childX, childY);
        }
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible()) continue;
            child.onPaint(gfx, partialTicks, childX, childY);
        }
    }

    @Override
    public void onPaintOverlay(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        int childX = this.parentToChildX(mouseX);
        int childY = this.parentToChildY(mouseY);
        for (IControl child : this) {
            if (!child.getVisible()) continue;
            child.onPaintOverlay(gfx, partialTicks, childX, childY);
        }
    }

    @Override
    public void onWindowClosed() {
        this.forEach(IControl::onWindowClosed);
    }

    @Override
    public void onThemeChanged(Theme newTheme) {
        super.onThemeChanged(newTheme);
        this.forEach(c -> c.onThemeChanged(newTheme));
    }

    @Override
    public Iterator<IControl> iterator() {
        return this._children.iterator();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" children:").append(this._children.size());
    }

    @Override
    protected void setControlOrigin(Point origin) {
        super.setControlOrigin(origin);
        this.updateChildrenControlOrigin();
    }

    protected AbstractCompoundControl(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
    }

    protected void addChildControl(@NotNull IControl control) {
        this._children.add(control);
        control.setParent(this);
    }

    protected void addChildControl(IControl ... controls) {
        for (IControl control : controls) {
            this._children.add(control);
            control.setParent(this);
        }
    }

    protected void removeChildControl(@NotNull IControl control) {
        this._children.remove(control);
        control.setParent(null);
    }

    protected void removeChildrenControls() {
        this._children.forEach(child -> child.setParent(null));
        this._children.clear();
    }

    protected int getChildrenControlsCount() {
        return this._children.size();
    }

    protected int parentToChildX(int parentX) {
        return parentX - this.getBounds().Origin.X;
    }

    protected int parentToChildY(int parentY) {
        return parentY - this.getBounds().Origin.Y;
    }

    protected int childToParentX(int childX) {
        return childX + this.getBounds().Origin.X;
    }

    protected int childToParentY(int childY) {
        return childY + this.getBounds().Origin.Y;
    }

    private void updateChildrenControlOrigin() {
        Point newOrigin = this.getOrigin().offset(this.getBounds().Origin);
        for (IControl child : this) {
            if (!(child instanceof AbstractControl)) continue;
            ((AbstractControl)child).setControlOrigin(newOrigin);
        }
    }
}

