/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.collect.Maps;
import java.lang.ref.SoftReference;
import java.util.Map;

public final class Padding {
    public static final Padding ZERO;
    private final int _left;
    private final int _right;
    private final int _top;
    private final int _bottom;
    private static final Map<Integer, SoftReference<Padding>> s_cache;

    public static Padding get(int left, int right, int top, int bottom) {
        Padding padding;
        int hash = Padding.pack(left = Padding.clamp(left), right = Padding.clamp(right), top = Padding.clamp(top), bottom = Padding.clamp(bottom));
        SoftReference<Padding> ref = s_cache.get(hash);
        if (null == ref || null == (padding = ref.get())) {
            padding = new Padding(left, right, top, bottom);
            ref = new SoftReference<Padding>(padding);
            s_cache.put(hash, ref);
        }
        return padding;
    }

    public int getLeft() {
        return this._left;
    }

    public int getRight() {
        return this._right;
    }

    public int getTop() {
        return this._top;
    }

    public int getBottom() {
        return this._bottom;
    }

    public int getHorizontal() {
        return this._left + this._right;
    }

    public int getVertical() {
        return this._top + this._bottom;
    }

    public String toString() {
        return String.format("[%d - %d - %d - %d]", this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    private Padding(int left, int right, int top, int bottom) {
        this._left = Padding.clamp(left);
        this._right = Padding.clamp(right);
        this._top = Padding.clamp(top);
        this._bottom = Padding.clamp(bottom);
    }

    private static int clamp(int value) {
        return Math.max(0, Math.min(100, value));
    }

    private static int pack(int byte1, int byte2, int byte3, int byte4) {
        return byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
    }

    static {
        s_cache = Maps.newHashMap();
        ZERO = Padding.get(0, 0, 0, 0);
    }
}

