/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.ITileCommandDispatcher;
import it.zerono.mods.zerocore.lib.block.ITileCommandHandler;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.LogicalSide;

public class TileCommandDispatcher<T extends AbstractModBlockEntity>
implements ITileCommandDispatcher {
    private final T _tile;
    private final Map<String, ITileCommandHandler<T>> _handlers;

    public static <T extends AbstractModBlockEntity> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public void dispatch(LogicalSide source, String name, CompoundTag parameters) {
        this._handlers.getOrDefault(name, (t, s, p) -> Log.LOGGER.error("No handler for Tile Command {}", (Object)name)).handle((AbstractModBlockEntity)this._tile, source, parameters);
    }

    private TileCommandDispatcher(T tile, Map<String, ITileCommandHandler<T>> map) {
        this._tile = tile;
        this._handlers = map;
    }

    public static class Builder<T extends AbstractModBlockEntity>
    implements ITileCommandDispatcher.Builder<T> {
        private final Map<String, ITileCommandHandler<T>> _handlers = Maps.newHashMap();

        @Override
        public ITileCommandDispatcher.Builder<T> addHandler(String name, ITileCommandHandler<T> handler) {
            this._handlers.put(name, handler);
            return this;
        }

        @Override
        public ITileCommandDispatcher build(T tile) {
            return new TileCommandDispatcher<T>(tile, this._handlers);
        }

        private Builder() {
        }
    }
}

