/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import observable.server.ServerSettingsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lobservable/server/TaggedSampler;", "Ljava/lang/Runnable;", "", "run", "()V", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "<init>", "(Ljava/lang/Thread;)V", "observable"})
public final class TaggedSampler
implements Runnable {
    @NotNull
    private final Thread thread;

    public TaggedSampler(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.thread = thread;
    }

    @NotNull
    public final Thread getThread() {
        return this.thread;
    }

    @Override
    public void run() {
        Observable.INSTANCE.getLOGGER().info("Started sampler thread");
        long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
        long deviation = ServerSettingsKt.getServerSettings().getDeviation();
        Object[] trace = null;
        Profiler.TimingData target = null;
        if (interval > 0L) {
            while (!Props.notProcessing) {
                if (Props.currentTarget.get() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)this.thread.getStackTrace(), (String)"getStackTrace(...)");
                target.getTraces().add(ArraysKt.toList((Object[])trace));
                Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
            }
        } else {
            while (!Props.notProcessing) {
                if (Props.currentTarget.get() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)this.thread.getStackTrace(), (String)"getStackTrace(...)");
                target.getTraces().add(ArraysKt.toList((Object[])trace));
            }
        }
    }
}

