/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import com.supermartijn642.durabilitytooltip.TooltipColorStyle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum TooltipStyle {
    BAR,
    NUMBERS,
    TEXT;


    public void appendTooltip(List<Component> tooltips, int durability, int maxDurability) {
        boolean showTooltipHint = DurabilityTooltipConfig.showTooltipHint.get();
        ChatFormatting baseColor = DurabilityTooltipConfig.baseTooltipColor.get();
        TooltipColorStyle colorStyle = DurabilityTooltipConfig.tooltipColorStyle.get();
        ChatFormatting reactiveColor = colorStyle.getColorForDurability(baseColor, durability, maxDurability);
        switch (this) {
            case BAR: {
                if (showTooltipHint) {
                    tooltips.add((Component)Component.m_237115_((String)"durabilitytooltip.info.bar.durability_hint").m_130940_(baseColor));
                }
                int fullCharacters = Math.round(10.0f * (float)durability / (float)maxDurability);
                MutableComponent innerBar = Component.m_237113_((String)"");
                for (int character = 0; character < 10; ++character) {
                    innerBar.m_7220_((Component)Component.m_237115_((String)(character < fullCharacters ? "durabilitytooltip.info.bar.full_symbol" : "durabilitytooltip.info.bar.empty_symbol")).m_130940_(reactiveColor));
                }
                MutableComponent bar = Component.m_237110_((String)"durabilitytooltip.info.bar.bar_line", (Object[])new Object[]{innerBar}).m_130940_(baseColor);
                tooltips.add((Component)bar);
                break;
            }
            case NUMBERS: {
                MutableComponent durabilityComponent = Component.m_237113_((String)Integer.toString(durability)).m_130940_(reactiveColor);
                MutableComponent maxDurabilityComponent = Component.m_237113_((String)Integer.toString(maxDurability)).m_130940_(colorStyle == TooltipColorStyle.VARYING ? baseColor : reactiveColor);
                MutableComponent numbers = durability == maxDurability ? Component.m_237110_((String)"durabilitytooltip.info.numbers.full_durability", (Object[])new Object[]{maxDurabilityComponent}).m_130940_(baseColor) : Component.m_237110_((String)"durabilitytooltip.info.numbers.damaged", (Object[])new Object[]{durabilityComponent, maxDurabilityComponent}).m_130940_(baseColor);
                if (showTooltipHint) {
                    numbers = Component.m_237110_((String)"durabilitytooltip.info.numbers.durability_hint", (Object[])new Object[]{numbers}).m_130940_(baseColor);
                }
                tooltips.add((Component)numbers);
                break;
            }
            case TEXT: {
                String translationKey = durability == maxDurability ? "durabilitytooltip.info.text.full_durability" : ((float)durability >= 0.4f * (float)maxDurability ? "durabilitytooltip.info.text.damaged" : ((float)durability >= 0.1f * (float)maxDurability ? "durabilitytooltip.info.text.severely_damaged" : "durabilitytooltip.info.text.nearly_broken"));
                MutableComponent tooltip = Component.m_237115_((String)translationKey).m_130940_(reactiveColor);
                if (showTooltipHint) {
                    tooltip = Component.m_237110_((String)"durabilitytooltip.info.text.durability_hint", (Object[])new Object[]{tooltip}).m_130940_(baseColor);
                }
                tooltips.add((Component)tooltip);
            }
        }
    }
}

