/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.supermartijn642.additionallanterns.AdditionalLanternsClient;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.additionallanterns.VanillaLanternEvents;
import com.supermartijn642.additionallanterns.data.LanternBlockModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternBlockStateGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternLanguageGenerator;
import com.supermartijn642.additionallanterns.data.LanternLootTableGenerator;
import com.supermartijn642.additionallanterns.data.LanternRecipeGenerator;
import com.supermartijn642.additionallanterns.data.LanternTagGenerator;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="additionallanterns")
public class AdditionalLanterns {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"additionallanterns", AdditionalLanterns::randomLantern).filler(items -> {
        for (LanternMaterial material : LanternMaterial.values()) {
            if (material == LanternMaterial.NORMAL) {
                items.accept(Items.f_42778_.m_7968_());
            } else {
                items.accept(material.getLanternBlock().m_5456_().m_7968_());
            }
            for (LanternColor color : LanternColor.values()) {
                items.accept(material.getLanternBlock(color).m_5456_().m_7968_());
            }
            if (!material.hasChains) continue;
            items.accept(material.getChainBlock().m_5456_().m_7968_());
        }
    });
    public static final Logger LOGGER = CommonUtils.getLogger((String)"additionallanterns");
    private static final Random RANDOM = new Random();

    private static ItemStack randomLantern() {
        LanternMaterial material = LanternMaterial.values()[RANDOM.nextInt(LanternMaterial.values().length)];
        int colorIndex = RANDOM.nextInt(LanternColor.values().length + 1);
        LanternColor color = colorIndex < LanternColor.values().length ? LanternColor.values()[colorIndex] : null;
        Item item = material == LanternMaterial.NORMAL && color == null ? Items.f_42778_ : material.getLanternBlock(color).m_5456_();
        return item.m_7968_();
    }

    public AdditionalLanterns() {
        VanillaLanternEvents.registerEventHandlers();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AdditionalLanterns::init);
        AdditionalLanterns.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> AdditionalLanternsClient::register);
        AdditionalLanterns.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"additionallanterns");
        for (LanternMaterial material : LanternMaterial.values()) {
            handler.registerBlockCallback(material::registerBlocks);
            handler.registerItemCallback(material::registerItems);
        }
    }

    public static void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            try {
                System.out.println("Class: " + HoneycombItem.f_150863_.getClass());
                Field delegateField = HoneycombItem.f_150863_.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Supplier oldWaxables = (Supplier)delegateField.get(HoneycombItem.f_150863_);
                delegateField.set(HoneycombItem.f_150863_, Suppliers.memoize(() -> AdditionalLanterns.lambda$init$2((Supplier)oldWaxables)));
                delegateField = WeatheringCopper.f_154886_.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Supplier oldWeathering = (Supplier)delegateField.get(WeatheringCopper.f_154886_);
                delegateField.set(WeatheringCopper.f_154886_, Suppliers.memoize(() -> AdditionalLanterns.lambda$init$3((Supplier)oldWeathering)));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to replace waxing and weathering maps! Copper lanterns will not be waxable or oxidize!", (Throwable)exception);
            }
        });
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"additionallanterns");
        handler.addGenerator(LanternBlockModelGenerator::new);
        handler.addGenerator(LanternItemModelGenerator::new);
        handler.addGenerator(LanternBlockStateGenerator::new);
        handler.addGenerator(LanternLanguageGenerator::new);
        handler.addGenerator(LanternLootTableGenerator::new);
        handler.addGenerator(LanternTagGenerator::new);
        handler.addGenerator(LanternRecipeGenerator::new);
    }

    private static /* synthetic */ ImmutableBiMap lambda$init$3(Supplier oldWeathering) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)LanternMaterial.COPPER.getLanternBlock(), (Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(), (Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(), (Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.COPPER.getChainBlock(), (Object)LanternMaterial.EXPOSED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getChainBlock(), (Object)LanternMaterial.WEATHERED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getChainBlock(), (Object)LanternMaterial.OXIDIZED_COPPER.getChainBlock());
        for (LanternColor color : LanternColor.values()) {
            builder.put((Object)LanternMaterial.COPPER.getLanternBlock(color), (Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color), (Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(color));
        }
        builder.putAll((Map)oldWeathering.get());
        return builder.build();
    }

    private static /* synthetic */ ImmutableBiMap lambda$init$2(Supplier oldWaxables) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)LanternMaterial.COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getChainBlock());
        for (LanternColor color : LanternColor.values()) {
            builder.put((Object)LanternMaterial.COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getLanternBlock(color));
        }
        builder.putAll((Map)oldWaxables.get());
        return builder.build();
    }
}

