/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();
    @Deprecated(forRemoval=true)
    public static final WoodType OAK_TYPE = VanillaWoodTypes.OAK;
    private final Map<net.minecraft.world.level.block.state.properties.WoodType, WoodType> fromVanilla = new IdentityHashMap<net.minecraft.world.level.block.state.properties.WoodType, WoodType>();
    public static Set<String> BLACKLISTED_MODS = new HashSet<String>(Set.of("chipped", "compressedblocks", "securitycraft", "absentbydesign", "immersive_weathering", "dynamictrees", "dt"));

    @Deprecated(forRemoval=true)
    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static WoodType getValue(ResourceLocation woodTypeId) {
        return (WoodType)INSTANCE.get(woodTypeId);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static WoodType getValue(String woodTypeId) {
        return (WoodType)INSTANCE.get(new ResourceLocation(woodTypeId));
    }

    @Deprecated(forRemoval=true)
    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    @Deprecated(forRemoval=true)
    public static WoodType fromVanilla(net.minecraft.world.level.block.state.properties.WoodType vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            WoodType b = new WoodType(new ResourceLocation("bamboo"), Blocks.f_244477_, Blocks.f_256831_);
            b.addChild("stripped_log", Blocks.f_256740_);
            return Optional.of(b);
        });
    }

    @Override
    protected WoodType register(WoodType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public WoodType getDefaultType() {
        return VanillaWoodTypes.OAK;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        BlockState state;
        String name = null;
        String path = baseRes.m_135815_();
        if (baseRes.m_135827_().equals("tfc") || baseRes.m_135827_().equals("afc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(baseRes.m_135827_(), path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.m_135827_();
        if (name != null && !BLACKLISTED_MODS.contains(namespace) && (state = baseBlock.m_49966_()).m_61147_().size() <= 2 && !(baseBlock instanceof SlabBlock)) {
            name = name.replace("/", "_");
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            Block logBlock = WoodType.findLog(id);
            if (logBlock != null && !this.valuesReg.containsKey(id)) {
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    public WoodType getFromVanilla(net.minecraft.world.level.block.state.properties.WoodType woodType) {
        if (this.fromVanilla.isEmpty()) {
            for (WoodType w : this.getValues()) {
                net.minecraft.world.level.block.state.properties.WoodType vanilla = w.toVanilla();
                if (vanilla == null) continue;
                this.fromVanilla.put(vanilla, w);
            }
        }
        return this.fromVanilla.get(woodType);
    }

    public WoodType.Finder addSimpleFinder(ResourceLocation woodTypeId) {
        WoodType.Finder finder = new WoodType.Finder(woodTypeId);
        this.addFinder(finder);
        return finder;
    }

    public WoodType.Finder addSimpleFinder(String nameWoodType) {
        return this.addSimpleFinder(new ResourceLocation(nameWoodType));
    }

    public WoodType.Finder addSimpleFinder(String namespace, String nameWoodType) {
        return this.addSimpleFinder(new ResourceLocation(namespace, nameWoodType));
    }
}

