/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.common.block.entity.dynamo;

import cofh.lib.api.StorageGroup;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.dynamo.DisenchantmentFuelManager;
import cofh.thermal.expansion.common.inventory.dynamo.DynamoDisenchantmentMenu;
import cofh.thermal.expansion.init.registries.TExpBlockEntities;
import cofh.thermal.lib.common.block.entity.DynamoBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DynamoDisenchantmentBlockEntity
extends DynamoBlockEntity {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && DisenchantmentFuelManager.instance().validFuel(item));

    public DynamoDisenchantmentBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpBlockEntities.DYNAMO_DISENCHANTMENT_TILE.get(), pos, state);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return DisenchantmentFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return DisenchantmentFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) > 0;
    }

    protected void processStart() {
        int fuelVal = Math.round((float)DisenchantmentFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) * this.energyMod);
        this.processTick = Math.min(this.baseProcessTick, fuelVal);
        this.fuelMax = fuelVal;
        this.fuel += this.fuelMax;
        this.fuelSlot.consume(1);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoDisenchantmentMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

