/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.client;

import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.filter.network.PacketSyncHandItem;
import mcjty.rftoolsbase.modules.tablet.TabletModule;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class GuiTablet
extends GenericGuiContainer<GenericTileEntity, TabletContainer> {
    public static final int TABLET_WIDTH = 180;
    public static final int TABLET_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/tablet.png");
    private ToggleButton[] buttons;

    public GuiTablet(TabletContainer container, Inventory inventory) {
        super(null, (AbstractContainerMenu)container, inventory, TabletItem.MANUAL);
        this.f_97726_ = 180;
        this.f_97727_ = 188;
    }

    public static void register() {
        MenuScreens.m_96206_(TabletModule.CONTAINER_TABLET.get(), GuiTablet::createTabletGui);
    }

    @Nonnull
    private static GuiTablet createTabletGui(TabletContainer container, Inventory inventory, Component textComponent) {
        return new GuiTablet(container, inventory);
    }

    public void m_7856_() {
        super.m_7856_();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        this.buttons = new ToggleButton[6];
        for (int i = 0; i < 6; ++i) {
            int finalI = i;
            this.buttons[i] = ((ToggleButton)new ToggleButton().hint(14 + i * 23, 32, 19, 8)).event(() -> this.setActive(finalI));
            toplevel.children(new Widget[]{this.buttons[i]});
        }
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void updateActiveButton(int current) {
        for (int i = 0; i < 6; ++i) {
            this.buttons[i].pressed(i == current);
        }
    }

    private InteractionHand getHand() {
        if (this.f_96541_.f_91074_ == null || this.f_96541_.f_91074_.m_7655_() == null) {
            return InteractionHand.MAIN_HAND;
        }
        return this.f_96541_.f_91074_.m_7655_();
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int p_230451_2_, int p_230451_3_) {
        super.m_280003_(graphics, p_230451_2_, p_230451_3_);
        ItemStack heldItem = this.f_96541_.f_91074_.m_21120_(this.getHand());
        this.updateActiveButton(TabletItem.getCurrentSlot(heldItem));
    }

    private void setActive(int i) {
        ItemStack heldItem = this.f_96541_.f_91074_.m_21120_(this.getHand());
        TabletItem.setCurrentSlot((Player)this.f_96541_.f_91074_, heldItem, i);
        this.updateActiveButton(i);
        this.syncStack();
    }

    private void syncStack() {
        RFToolsBaseMessages.sendToServer(PacketSyncHandItem.create((Player)this.f_96541_.f_91074_));
    }
}

