/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelleConfig;

public class EntityPoisonousLibelle
extends FlyingMob
implements Enemy {
    private static final int POISON_DURATION = 2;
    public double targetX;
    public double targetY;
    public double targetZ;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    private Entity target;
    private static int WINGLENGTH;
    private int wingProgress = 0;
    private boolean wingGoUp = true;
    private static final int MAXHEIGHT = 80;
    private float randomYawVelocity;

    public EntityPoisonousLibelle(EntityType<? extends EntityPoisonousLibelle> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.f_21364_ = 10;
    }

    public EntityPoisonousLibelle(Level world) {
        this(RegistryEntries.ENTITY_POISONOUS_LIBELLE, world);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void checkLibelleSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof EntityPoisonousLibelle && event.getEntity().m_20186_() < (double)EntityPoisonousLibelleConfig.minY) {
            event.setSpawnCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    public SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11733_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11732_;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_8107_() {
        float f;
        super.m_8107_();
        if (this.m_9236_().m_5776_()) {
            f = Mth.m_14089_((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = Mth.m_14089_((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.f_19796_.m_188503_(45) == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11731_, SoundSource.AMBIENT, 0.1f, 0.8f + this.f_19796_.m_188501_() * 0.3f);
            }
        }
        this.prevAnimTime = this.animTime;
        Vec3 m = this.m_20184_();
        f = 0.2f / (Mth.m_14116_((float)((float)(m.f_82479_ * m.f_82479_ + m.f_82481_ * m.f_82481_))) * 10.0f + 1.0f);
        this.animTime += (f *= (float)Math.pow(2.0, m.f_82480_));
        if (this.m_9236_().m_5776_()) {
            if (this.f_20903_ > 0) {
                double distanceX = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                double distanceY = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                double distanceZ = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                double distance = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                this.m_146922_((float)((double)this.m_146908_() + distance / (double)this.f_20903_));
                this.m_146926_((float)((double)this.m_146909_() + (this.targetX - (double)this.m_146909_()) / (double)this.f_20903_));
                --this.f_20903_;
                this.m_6034_(distanceX, distanceY, distanceZ);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
        } else {
            float limitDistanceY;
            double distanceX = this.targetX - this.m_20185_();
            double distanceY = this.targetY - this.m_20186_();
            double distanceZ = this.targetZ - this.m_20189_();
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (this.target != null) {
                double distancedZ;
                this.targetX = this.target.m_20185_();
                this.targetZ = this.target.m_20189_();
                double distancedX = this.targetX - this.m_20185_();
                double distancedHeightPlane = Math.sqrt(distancedX * distancedX + (distancedZ = this.targetZ - this.m_20189_()) * distancedZ);
                double Yplus = 0.4 + distancedHeightPlane / 80.0 - 1.0;
                if (Yplus > 10.0) {
                    Yplus = 10.0;
                }
                this.targetY = Math.min(this.target.m_20191_().f_82289_ + Yplus, 80.0);
            } else {
                this.targetX += (this.f_19796_.m_188500_() * 2.0 - 1.0) * 2.0;
                this.targetZ += (this.f_19796_.m_188500_() * 2.0 - 1.0) * 2.0;
            }
            if (this.forceNewTarget || distance < 3.0 || distance > 250.0 || this.f_19862_ || this.f_19863_ || this.targetY > 80.0) {
                this.setNewTarget();
            }
            if ((distanceY /= (double)Mth.m_14116_((float)((float)(distanceX * distanceX + distanceZ * distanceZ)))) < (double)(-(limitDistanceY = 0.6f))) {
                distanceY = -limitDistanceY;
            }
            if (distanceY > (double)limitDistanceY) {
                distanceY = limitDistanceY;
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, distanceY * 0.1, 0.0));
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            double newYaw = 180.0 - Math.atan2(distanceX, distanceZ) * 180.0 / Math.PI;
            double differenceYaw = Mth.m_14175_((double)(newYaw - (double)this.m_146908_()));
            double limitDifferenceYaw = 50.0;
            if (differenceYaw > limitDifferenceYaw) {
                differenceYaw = limitDifferenceYaw;
            }
            if (differenceYaw < -limitDifferenceYaw) {
                differenceYaw = -limitDifferenceYaw;
            }
            Vec3 distanceVector = new Vec3(this.targetX - this.m_20185_(), this.targetY - this.m_20186_(), this.targetZ - this.m_20189_()).m_82541_();
            Vec3 rotationVector = new Vec3((double)Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)), m.f_82480_, (double)(-Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)))).m_82541_();
            float dynamicMotionMultiplier = (float)(rotationVector.m_82526_(distanceVector) + 0.5) / 1.5f;
            if (dynamicMotionMultiplier < 0.0f) {
                dynamicMotionMultiplier = 0.0f;
            }
            this.randomYawVelocity *= 0.8f;
            float motionDistanceHeightPlaneFloat = Mth.m_14116_((float)((float)(m.f_82479_ * m.f_82479_ + m.f_82481_ * m.f_82481_))) * 1.0f + 1.0f;
            double motionDistanceHeightPlane = Math.sqrt(m.f_82479_ * m.f_82479_ + m.f_82481_ * m.f_82481_) * 1.0 + 1.0;
            if (motionDistanceHeightPlane > 40.0) {
                motionDistanceHeightPlane = 40.0;
            }
            this.randomYawVelocity = (float)((double)this.randomYawVelocity + differenceYaw * (0.7 / motionDistanceHeightPlane / (double)motionDistanceHeightPlaneFloat));
            this.m_146922_(this.m_146908_() + this.randomYawVelocity * 0.1f);
            float scaledMotionDistanceHeightPlane = (float)(2.0 / (motionDistanceHeightPlane + 1.0));
            float staticMotionMultiplier = 0.03f;
            this.m_19920_(staticMotionMultiplier * (dynamicMotionMultiplier * scaledMotionDistanceHeightPlane + (1.0f - scaledMotionDistanceHeightPlane)), new Vec3(0.0, 0.0, -1.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 vec3d3 = this.m_20184_().m_82541_();
            double d6 = 0.8 + 0.15 * (vec3d3.m_82526_(rotationVector) + 1.0) / 2.0;
            this.m_20256_(this.m_20184_().m_82542_(d6, (double)0.91f, d6));
        }
        this.f_20883_ = this.m_146908_();
        if (!this.m_9236_().m_5776_() && this.f_20916_ == 0 && this.m_6084_()) {
            this.attackEntitiesInList(this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 0.0, 1.0)));
        }
        if (this.wingGoUp) {
            ++this.wingProgress;
            if (this.wingProgress > WINGLENGTH) {
                this.wingGoUp = false;
            }
        } else {
            --this.wingProgress;
            if (this.wingProgress < -WINGLENGTH) {
                this.wingGoUp = true;
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        int chance = EntityPoisonousLibelleConfig.poisonChance;
        for (Entity entity : entities) {
            if (chance <= 0 || this.m_9236_().f_46441_.m_188503_(chance) != 0 || !(entity instanceof LivingEntity)) continue;
            boolean shouldAttack = true;
            if (entity instanceof Player && ((Player)entity).m_7500_()) {
                shouldAttack = false;
                this.setNewTarget();
            }
            if (!shouldAttack) continue;
            if (EntityPoisonousLibelleConfig.hasAttackDamage) {
                entity.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 0.5f);
            }
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 1));
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        boolean targetSet = false;
        if (this.f_19796_.m_188503_(2) == 0 && !this.m_9236_().m_6907_().isEmpty() && !this.m_9236_().m_46461_()) {
            this.target = (Entity)this.m_9236_().m_6907_().get(this.f_19796_.m_188503_(this.m_9236_().m_6907_().size()));
            targetSet = true;
            if (this.target instanceof Player && ((Player)this.target).m_7500_()) {
                targetSet = false;
            }
        }
        if (!targetSet) {
            double d2;
            double d1;
            double d0;
            boolean flag;
            do {
                this.targetX = this.m_20185_();
                this.targetY = 80.0f - this.f_19796_.m_188501_() * 30.0f;
                this.targetZ = this.m_20189_();
                this.targetX += (double)(this.f_19796_.m_188501_() * 120.0f - 60.0f);
                this.targetZ += (double)(this.f_19796_.m_188501_() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.m_20185_() - this.targetX) * d0 + (d1 = this.m_20186_() - this.targetY) * d1 + (d2 = this.m_20189_() - this.targetZ) * d2 > 20.0));
            this.target = null;
        }
    }

    public float getWingProgressScaled(float scale) {
        return (float)this.wingProgress / (float)WINGLENGTH * scale;
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityPoisonousLibelle.class);
        WINGLENGTH = 4;
    }
}

