/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.DamageableItemRepairAction;
import org.cyclops.evilcraft.enchantment.EnchantmentVengeanceConfig;
import org.cyclops.evilcraft.item.ItemVengeanceRing;

public class EnchantmentVengeance
extends Enchantment {
    public EnchantmentVengeance() {
        super(Enchantment.Rarity.COMMON, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        DamageableItemRepairAction.BAD_ENCHANTS.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6183_(int level) {
        return 1 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6589_() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        int level;
        InteractionHand hand;
        Player player = event.getPlayer();
        if (player != null && !player.m_9236_().m_5776_() && (hand = event.getPlayer().m_7655_()) != null && (level = EnchantmentVengeance.getEnchantLevel(heldItem = player.m_21120_(hand))) > 0) {
            EnchantmentVengeance.apply(player.m_9236_(), level, (LivingEntity)player);
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        ItemStack heldItem;
        int level;
        Player player;
        InteractionHand hand;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && !entity.m_9236_().m_5776_() && (hand = (player = (Player)entity).m_7655_()) != null && (level = EnchantmentVengeance.getEnchantLevel(heldItem = player.m_21120_(hand))) > 0) {
            EnchantmentVengeance.apply(player.m_9236_(), level, (LivingEntity)player);
        }
    }

    public static int getEnchantLevel(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        return EnchantmentHelper.m_44843_((Enchantment)RegistryEntries.ENCHANTMENT_VENGEANCE, (ItemStack)itemStack);
    }

    public static void apply(Level world, int level, LivingEntity entity) {
        int chance;
        if (level > 0 && (chance = Math.max(1, EnchantmentVengeanceConfig.vengeanceChance / level)) > 0 && world.f_46441_.m_188503_(chance) == 0) {
            int area = EnchantmentVengeanceConfig.areaOfEffect * level;
            ItemVengeanceRing.toggleVengeanceArea(world, (Entity)entity, area, true, true, true);
        }
    }
}

