/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.inventory.container.ContainerInventoryTickingTank;

public abstract class ContainerTileWorking<T extends BlockEntityWorking<T, ?>>
extends ContainerInventoryTickingTank<T> {
    public ContainerTileWorking(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, Optional<T> tileSupplier, int tickers, int upgradeSlots) {
        super(type, id, playerInventory, inventory, tileSupplier, tickers);
        this.offsetX = 28;
    }

    public boolean isUpgradeSlotEnabled(int slot) {
        return this.getTileWorkingMetadata().isUpgradeSlotEnabled(this.inventory, this.getTileWorkingMetadata().getBasicInventorySize() + slot);
    }

    public abstract BlockEntityWorking.Metadata getTileWorkingMetadata();

    public void addUpgradeInventory(int offsetX, int offsetY, int slotStart) {
        int upgradeSlots = 4;
        int amount = 0;
        for (int i = slotStart; i < slotStart + upgradeSlots; ++i) {
            this.m_38897_((Slot)new SlotExtended(this.inventory, i, offsetX, offsetY + amount * 18){
                private ItemStack lastSlotContents;
                {
                    this.lastSlotContents = this.m_7993_();
                }

                public boolean m_5857_(ItemStack itemStack) {
                    return super.m_5857_(itemStack) && ContainerTileWorking.this.getTileWorkingMetadata().canInsertItem(this.f_40218_, this.getSlotIndex(), itemStack);
                }

                public boolean m_8010_(Player playerIn) {
                    return super.m_8010_(ContainerTileWorking.this.player) && ContainerTileWorking.this.getTileWorkingMetadata().canExtractItem(this.f_40218_, this.getSlotIndex(), this.m_7993_(), ContainerTileWorking.this.m_142621_());
                }

                public void m_6654_() {
                    if (!ItemStack.m_41728_((ItemStack)this.lastSlotContents, (ItemStack)this.m_7993_())) {
                        ContainerTileWorking.this.getTileSupplier().ifPresent(tile -> tile.onUpgradeSlotChanged(this.getSlotIndex(), this.lastSlotContents, this.m_7993_()));
                    }
                    this.lastSlotContents = this.m_7993_();
                    if (!this.lastSlotContents.m_41619_()) {
                        this.lastSlotContents = this.lastSlotContents.m_41777_();
                    }
                }
            });
            ++amount;
        }
    }
}

