/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;
    public static final String NBT_KEY_ENABLED = "enabled";
    private static ItemStack bloodBucket = null;

    public static boolean isActivated(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41782_() && itemStack.m_41783_().m_128471_(NBT_KEY_ENABLED);
    }

    public static void toggleActivation(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            itemStack.m_41751_(tag);
        }
        if (ItemHelpers.isActivated(itemStack)) {
            tag.m_128473_(NBT_KEY_ENABLED);
        } else {
            tag.m_128379_(NBT_KEY_ENABLED, true);
        }
    }

    public static int getNBTInt(ItemStack itemStack, String tag) {
        if (itemStack.m_41619_() || itemStack.m_41783_() == null) {
            return 0;
        }
        return itemStack.m_41783_().m_128451_(tag);
    }

    public static void setNBTInt(ItemStack itemStack, int integer, String tag) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.m_41751_(tagCompound);
        }
        if (integer == 0) {
            tagCompound.m_128473_(tag);
        } else {
            tagCompound.m_128405_(tag, integer);
        }
    }

    public static void updateAutoFill(IFluidHandlerItem toDrain, Level world, Entity entity, boolean fillBuckets) {
        FluidStack tickFluid;
        if (entity instanceof Player && !world.m_5776_() && !(tickFluid = toDrain.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.m_21120_(hand);
                if (held.m_41619_() || !fillBuckets && held.m_41720_() == Items.f_42446_) continue;
                ItemStack toFill = held.m_41620_(1);
                ItemStack filled = ItemHelpers.tryFillContainerForPlayer(toDrain, toFill, tickFluid, player);
                if (!filled.m_41619_()) {
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, filled);
                        continue;
                    }
                    player.m_36356_(filled);
                    continue;
                }
                held.m_41769_(1);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IFluidHandlerItem toDrain, ItemStack toFill, FluidStack tickFluid, Player player) {
        int maxFill = MB_FILL_PERTICK;
        if (toFill.m_41720_() == Items.f_42446_) {
            maxFill = 1000;
        }
        if (!toFill.m_41619_() && toFill != toDrain.getContainer() && FluidUtil.getFluidHandler((ItemStack)toFill) != null && player.m_21212_() == 0 && FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), (Player)player, (boolean)false).isSuccess()) {
            return FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), null, (boolean)true).getResult();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getBloodBucket() {
        if (bloodBucket == null) {
            bloodBucket = new ItemStack((ItemLike)RegistryEntries.ITEM_BUCKET_BLOOD);
        }
        return bloodBucket;
    }
}

