/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleFartData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ParticleFartData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleFartData>(){

        public ParticleFartData fromCommand(ParticleType<ParticleFartData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean rainbow = reader.readBoolean();
            return new ParticleFartData(rainbow);
        }

        public ParticleFartData fromNetwork(ParticleType<ParticleFartData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleFartData(buffer.readBoolean());
        }
    };
    public static final Codec<ParticleFartData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("rainbow").forGetter(ParticleFartData::getRainbow)).apply((Applicative)builder, ParticleFartData::new));
    private final boolean rainbow;

    public ParticleFartData(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public boolean getRainbow() {
        return this.rainbow;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_FART;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.rainbow);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.rainbow);
    }
}

