/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.CollectPotionPurifyAction;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.DisenchantPurifyAction;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.ToolBadEnchantPurifyAction;

public class PurifierActionRegistry
implements IPurifierActionRegistry {
    private List<IPurifierAction> registry = Lists.newArrayList();

    public PurifierActionRegistry() {
        this.register(new ToolBadEnchantPurifyAction());
        this.register(new DisenchantPurifyAction());
        this.register(new CollectPotionPurifyAction());
    }

    @Override
    public void register(IPurifierAction purifyAction) {
        this.registry.add(purifyAction);
    }

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        for (IPurifierAction purifyAction : this.registry) {
            if (!purifyAction.isItemValidForMainSlot(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        for (IPurifierAction purifyAction : this.registry) {
            if (!purifyAction.isItemValidForAdditionalSlot(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int canWork(BlockEntityPurifier tile) {
        for (int i = 0; i < this.registry.size(); ++i) {
            IPurifierAction purifyAction = this.registry.get(i);
            if (!purifyAction.canWork(tile)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean work(int actionId, BlockEntityPurifier tile) {
        if (actionId < this.registry.size()) {
            return this.registry.get(actionId).work(tile);
        }
        return true;
    }
}

